<?php
require_once '../config/database.php';
require_once '../config/auth.php';
requireLogin('admin', 'index.php');

$db = Database::getInstance()->getConnection();
$sucesso = '';
$erro = '';

// Aprovar/Rejeitar parceiro
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['aprovar'])) {
        $id = intval($_POST['aprovar']);
        $stmt = $db->prepare("UPDATE empresas_parceiras SET status = 'aprovada' WHERE id = ?");
        $stmt->execute([$id]);
        $sucesso = 'Empresa parceira aprovada!';
    }
    
    if (isset($_POST['rejeitar'])) {
        $id = intval($_POST['rejeitar']);
        $obs = trim($_POST['observacao'] ?? '');
        $stmt = $db->prepare("UPDATE empresas_parceiras SET status = 'rejeitada', observacoes = ? WHERE id = ?");
        $stmt->execute([$obs, $id]);
        $sucesso = 'Empresa parceira rejeitada.';
    }
    
    if (isset($_POST['excluir'])) {
        $id = intval($_POST['excluir']);
        $stmt = $db->prepare("DELETE FROM empresas_parceiras WHERE id = ?");
        $stmt->execute([$id]);
        $sucesso = 'Cadastro excluído.';
    }
}

// Filtro
$filtro = $_GET['status'] ?? '';
$where = '';
$params = [];
if ($filtro && in_array($filtro, ['pendente', 'aprovada', 'rejeitada'])) {
    $where = "WHERE status = ?";
    $params[] = $filtro;
}

// Buscar parceiros
$stmt = $db->prepare("SELECT * FROM empresas_parceiras $where ORDER BY created_at DESC");
$stmt->execute($params);
$parceiros = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Contadores
$stmt = $db->query("SELECT status, COUNT(*) as total FROM empresas_parceiras GROUP BY status");
$contadores = ['pendente' => 0, 'aprovada' => 0, 'rejeitada' => 0];
while ($row = $stmt->fetch()) {
    $contadores[$row['status']] = $row['total'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Empresas Parceiras - Admin</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <script src="../assets/js/admin-theme.js"></script>
    <style>
        .parceiro-card {
            background: var(--bg-secondary);
            border-radius: 12px;
            padding: 20px;
            margin-bottom: 16px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
        }
        .parceiro-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 16px;
        }
        .parceiro-nome {
            font-size: 18px;
            font-weight: 600;
            color: var(--text-primary);
        }
        .parceiro-cnpj {
            color: var(--text-secondary);
            font-size: 14px;
        }
        .parceiro-info {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 12px;
            margin-bottom: 16px;
        }
        .parceiro-info-item {
            font-size: 14px;
        }
        .parceiro-info-item label {
            color: #666;
            display: block;
            font-size: 12px;
        }
        .parceiro-acoes {
            display: flex;
            gap: 10px;
            padding-top: 16px;
            border-top: 1px solid #eee;
        }
        .badge-pendente { background: #ffc107; color: #333; }
        .badge-aprovada { background: #4caf50; color: white; }
        .badge-rejeitada { background: #f44336; color: white; }
        .filtros {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            flex-wrap: wrap;
        }
        .filtro-btn {
            padding: 10px 20px;
            border: none;
            border-radius: 8px;
            background: #e0e0e0;
            color: #333;
            text-decoration: none;
            font-size: 14px;
            display: flex;
            align-items: center;
            gap: 8px;
        }
        .filtro-btn.active {
            background: #1a237e;
            color: white;
        }
        .filtro-btn .count {
            background: rgba(0,0,0,0.2);
            padding: 2px 8px;
            border-radius: 10px;
            font-size: 12px;
        }
        .modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.5);
            align-items: center;
            justify-content: center;
            z-index: 1000;
        }
        .modal.show {
            display: flex;
        }
        .modal-content {
            background: var(--bg-secondary);
            padding: 24px;
            border-radius: 12px;
            width: 100%;
            max-width: 400px;
            color: var(--text-primary);
        }
    </style>
</head>
<body class="admin-panel">
    <header class="header">
        <h1>⚙️ Já EntreGo Admin</h1>
        <nav>
            <a href="dashboard.php">Dashboard</a>
            <a href="entregas.php">Entregas</a>
            <a href="entregadores.php">Entregadores</a>
            <a href="usuarios.php">Usuários</a>
            <a href="parceiros.php">Parceiros</a>
            <a href="configuracoes.php">Configurações</a>
            <a href="perfil.php">Perfil</a>
            <a href="logout.php">Sair</a>
            <div class="theme-toggle">
                <button type="button" id="theme-toggle-btn" class="theme-toggle-btn" onclick="toggleTheme()" title="Alternar tema">🌙</button>
            </div>
        </nav>
    </header>
    
    <div class="container">
        <h2 style="margin-bottom: 20px;">🤝 Empresas Parceiras</h2>
        
        <?php if ($sucesso): ?>
            <div class="alert alert-success"><?= htmlspecialchars($sucesso) ?></div>
        <?php endif; ?>
        
        <!-- Filtros -->
        <div class="filtros">
            <a href="parceiros.php" class="filtro-btn <?= !$filtro ? 'active' : '' ?>">
                Todas <span class="count"><?= array_sum($contadores) ?></span>
            </a>
            <a href="parceiros.php?status=pendente" class="filtro-btn <?= $filtro === 'pendente' ? 'active' : '' ?>">
                ⏳ Pendentes <span class="count"><?= $contadores['pendente'] ?></span>
            </a>
            <a href="parceiros.php?status=aprovada" class="filtro-btn <?= $filtro === 'aprovada' ? 'active' : '' ?>">
                ✅ Aprovadas <span class="count"><?= $contadores['aprovada'] ?></span>
            </a>
            <a href="parceiros.php?status=rejeitada" class="filtro-btn <?= $filtro === 'rejeitada' ? 'active' : '' ?>">
                ❌ Rejeitadas <span class="count"><?= $contadores['rejeitada'] ?></span>
            </a>
        </div>
        
        <?php if (empty($parceiros)): ?>
            <div class="card" style="text-align: center; padding: 60px;">
                <div style="font-size: 60px; margin-bottom: 20px;">🤝</div>
                <h3>Nenhuma empresa parceira</h3>
                <p style="color: #666;">Os cadastros de empresas parceiras aparecerão aqui.</p>
            </div>
        <?php else: ?>
            <?php foreach ($parceiros as $p): ?>
                <div class="parceiro-card">
                    <div class="parceiro-header">
                        <div>
                            <div class="parceiro-nome"><?= htmlspecialchars($p['nome_empresa']) ?></div>
                            <div class="parceiro-cnpj">CNPJ: <?= htmlspecialchars($p['cnpj'] ?: 'Não informado') ?></div>
                        </div>
                        <span class="badge badge-<?= $p['status'] ?>">
                            <?= ucfirst($p['status']) ?>
                        </span>
                    </div>
                    
                    <div class="parceiro-info">
                        <div class="parceiro-info-item">
                            <label>Responsável</label>
                            <?= htmlspecialchars($p['responsavel'] ?: '-') ?>
                        </div>
                        <div class="parceiro-info-item">
                            <label>Email</label>
                            <a href="mailto:<?= htmlspecialchars($p['email']) ?>"><?= htmlspecialchars($p['email']) ?></a>
                        </div>
                        <div class="parceiro-info-item">
                            <label>Telefone</label>
                            <?= htmlspecialchars($p['telefone'] ?: '-') ?>
                        </div>
                        <div class="parceiro-info-item">
                            <label>Endereço</label>
                            <?= htmlspecialchars($p['endereco'] ?: '-') ?>
                        </div>
                    </div>
                    
                    <?php if ($p['observacoes']): ?>
                        <div style="background: #fff3e0; padding: 10px; border-radius: 8px; margin-bottom: 16px; font-size: 14px;">
                            <strong>Observações:</strong> <?= htmlspecialchars($p['observacoes']) ?>
                        </div>
                    <?php endif; ?>
                    
                    <div style="font-size: 12px; color: #999; margin-bottom: 12px;">
                        Cadastrado em <?= date('d/m/Y H:i', strtotime($p['created_at'])) ?>
                    </div>
                    
                    <div class="parceiro-acoes">
                        <?php if ($p['status'] === 'pendente'): ?>
                            <form method="POST" style="display: inline;">
                                <button type="submit" name="aprovar" value="<?= $p['id'] ?>" class="btn btn-success" style="padding: 8px 16px;">
                                    ✅ Aprovar
                                </button>
                            </form>
                            <button type="button" class="btn btn-danger" style="padding: 8px 16px;" onclick="abrirModalRejeitar(<?= $p['id'] ?>)">
                                ❌ Rejeitar
                            </button>
                        <?php endif; ?>
                        <form method="POST" style="display: inline; margin-left: auto;" onsubmit="return confirm('Excluir este cadastro?')">
                            <button type="submit" name="excluir" value="<?= $p['id'] ?>" class="btn" style="padding: 8px 16px; background: #e0e0e0;">
                                🗑️ Excluir
                            </button>
                        </form>
                    </div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>
    
    <!-- Modal Rejeitar -->
    <div class="modal" id="modal-rejeitar">
        <div class="modal-content">
            <h3 style="margin-bottom: 16px;">❌ Rejeitar Empresa</h3>
            <form method="POST">
                <input type="hidden" name="rejeitar" id="rejeitar-id">
                <div class="form-group">
                    <label>Motivo da rejeição</label>
                    <textarea name="observacao" class="form-control" rows="3" placeholder="Informe o motivo..."></textarea>
                </div>
                <div style="display: flex; gap: 10px;">
                    <button type="submit" class="btn btn-danger">Confirmar Rejeição</button>
                    <button type="button" class="btn" style="background: #e0e0e0;" onclick="fecharModal()">Cancelar</button>
                </div>
            </form>
        </div>
    </div>
    
    <script>
    function abrirModalRejeitar(id) {
        document.getElementById('rejeitar-id').value = id;
        document.getElementById('modal-rejeitar').classList.add('show');
    }
    
    function fecharModal() {
        document.getElementById('modal-rejeitar').classList.remove('show');
    }
    </script>
</body>
</html>
