<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';
require_once '../../config/helpers.php';
require_once '../../config/veiculo-inteligente.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    exit;
}

$userId = null;
if (isLoggedIn('usuario')) {
    $userId = getCurrentUserId('usuario');
}

if (!$userId) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

$origem = trim($_POST['origem'] ?? '');
$destino = trim($_POST['destino'] ?? '');
$descricao = trim($_POST['descricao'] ?? '');
$categoria = $_POST['categoria'] ?? 'moto';
$tipoCarga = $_POST['tipo_carga'] ?? 'outros';
$peso = floatval($_POST['peso'] ?? 0);

if (empty($origem) || empty($destino)) {
    echo json_encode(['success' => false, 'message' => 'Preencha os endereços']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Buscar configurações de preço
    $configs = [];
    $stmt = $db->query("SELECT chave, valor FROM configuracoes");
    while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
        $configs[$row['chave']] = $row['valor'];
    }
    
    $categorias = [
        'moto' => ['base' => floatval($configs['preco_base_moto'] ?? 8), 'km' => floatval($configs['preco_km_moto'] ?? 2)],
        'carro' => ['base' => floatval($configs['preco_base_carro'] ?? 12), 'km' => floatval($configs['preco_km_carro'] ?? 2.5)],
        'van' => ['base' => floatval($configs['preco_base_van'] ?? 20), 'km' => floatval($configs['preco_km_van'] ?? 3.5)],
        'caminhao' => ['base' => floatval($configs['preco_base_caminhao'] ?? 35), 'km' => floatval($configs['preco_km_caminhao'] ?? 5)],
    ];
    
    $valorMinimo = floatval($configs['valor_minimo_entrega'] ?? 10);
    $distancia = rand(2, 15); // Simulado - em produção usar Google Distance Matrix
    
    $cat = $categorias[$categoria] ?? $categorias['moto'];
    $valor = $cat['base'] + ($cat['km'] * $distancia);
    $valor = max($valor, $valorMinimo);
    $valor = round($valor, 2);
    
    $stmt = $db->prepare("
        INSERT INTO entregas (
            usuario_id, origem_endereco, destino_endereco, descricao, 
            valor, status, distancia, categoria_veiculo, peso_kg, tipo_carga
        ) VALUES (?, ?, ?, ?, ?, 'pendente', ?, ?, ?, ?)
    ");
    
    $stmt->execute([$userId, $origem, $destino, $descricao, $valor, $distancia, $categoria, $peso, $tipoCarga]);
    $entregaId = $db->lastInsertId();
    
    // Notificar entregadores
    $stmt = $db->prepare("SELECT id FROM entregadores WHERE status = 'disponivel' AND aprovado = 'aprovado' AND (bloqueado = 0 OR bloqueado IS NULL)");
    $stmt->execute();
    $entregadores = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($entregadores as $ent) {
        $stmt = $db->prepare("INSERT INTO notificacoes (entregador_id, entrega_id, mensagem) VALUES (?, ?, ?)");
        $stmt->execute([$ent['id'], $entregaId, 'Nova entrega disponível! R$ ' . number_format($valor, 2, ',', '.')]);
    }
    
    echo json_encode([
        'success' => true,
        'message' => 'Entrega solicitada!',
        'valor' => number_format($valor, 2, ',', '.'),
        'veiculo' => ucfirst($categoria)
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao criar entrega: ' . $e->getMessage()]);
}