<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

// Verificar autenticação via header ou session
$userId = null;
if (isLoggedIn('usuario')) {
    $userId = getCurrentUserId('usuario');
}

if (!$userId) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    $stmt = $db->prepare("
        SELECT e.*, ent.nome as entregador_nome, ent.telefone as entregador_telefone
        FROM entregas e
        LEFT JOIN entregadores ent ON e.entregador_id = ent.id
        WHERE e.usuario_id = ?
        ORDER BY e.created_at DESC
        LIMIT 50
    ");
    $stmt->execute([$userId]);
    $entregas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'entregas' => $entregas]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao carregar entregas']);
}