<?php
require_once '../../config/database.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Methods: POST');
header('Access-Control-Allow-Headers: Content-Type');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    exit;
}

$email = $_POST['email'] ?? '';
$senha = $_POST['senha'] ?? '';

if (empty($email) || empty($senha)) {
    echo json_encode(['success' => false, 'message' => 'Email e senha são obrigatórios']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    $stmt = $db->prepare("SELECT * FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$usuario || !password_verify($senha, $usuario['senha'])) {
        echo json_encode(['success' => false, 'message' => 'Email ou senha incorretos']);
        exit;
    }
    
    if (!empty($usuario['bloqueado']) && $usuario['bloqueado'] == 1) {
        echo json_encode(['success' => false, 'message' => 'Sua conta está bloqueada. Entre em contato com o suporte.']);
        exit;
    }
    
    // Gerar token simples (em produção, use JWT)
    $token = bin2hex(random_bytes(32));
    
    // Remover senha dos dados
    unset($usuario['senha']);
    
    echo json_encode([
        'success' => true,
        'token' => $token,
        'usuario' => $usuario
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro no servidor']);
}