<?php
require_once '../../config/database.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    exit;
}

$nome = trim($_POST['nome'] ?? '');
$email = trim($_POST['email'] ?? '');
$telefone = trim($_POST['telefone'] ?? '');
$cpf = trim($_POST['cpf'] ?? '');
$senha = $_POST['senha'] ?? '';
$veiculo = $_POST['veiculo'] ?? 'moto';
$placa = trim($_POST['placa'] ?? '');
$marca = trim($_POST['marca'] ?? '');
$modelo = trim($_POST['modelo'] ?? '');

if (empty($nome) || empty($email) || empty($senha) || empty($cpf)) {
    echo json_encode(['success' => false, 'message' => 'Preencha todos os campos obrigatórios']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Verificar se email já existe
    $stmt = $db->prepare("SELECT id FROM entregadores WHERE email = ?");
    $stmt->execute([$email]);
    if ($stmt->fetch()) {
        echo json_encode(['success' => false, 'message' => 'Este email já está cadastrado']);
        exit;
    }
    
    $senhaHash = password_hash($senha, PASSWORD_DEFAULT);
    $stmt = $db->prepare("
        INSERT INTO entregadores (nome, email, telefone, cpf, senha, veiculo, placa, veiculo_marca, veiculo_modelo, aprovado, status) 
        VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, 'pendente', 'offline')
    ");
    $stmt->execute([$nome, $email, $telefone, $cpf, $senhaHash, $veiculo, $placa, $marca, $modelo]);
    
    echo json_encode(['success' => true, 'message' => 'Cadastro enviado para análise!']);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao realizar cadastro']);
}