<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$entregadorId = null;
if (isLoggedIn('entregador')) {
    $entregadorId = getCurrentUserId('entregador');
}

if (!$entregadorId) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Status do entregador
    $stmt = $db->prepare("SELECT status FROM entregadores WHERE id = ?");
    $stmt->execute([$entregadorId]);
    $status = $stmt->fetch()['status'];
    
    // Entrega atual
    $stmt = $db->prepare("
        SELECT e.*, u.nome as cliente_nome, u.telefone as cliente_telefone
        FROM entregas e
        JOIN usuarios u ON e.usuario_id = u.id
        WHERE e.entregador_id = ? AND e.status IN ('aceita', 'coletada')
        LIMIT 1
    ");
    $stmt->execute([$entregadorId]);
    $entregaAtual = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Entregas disponíveis
    $entregasDisponiveis = [];
    if (!$entregaAtual && $status === 'disponivel') {
        $stmt = $db->prepare("
            SELECT e.*, u.nome as cliente_nome
            FROM entregas e
            JOIN usuarios u ON e.usuario_id = u.id
            WHERE e.status = 'pendente'
            ORDER BY e.created_at DESC
        ");
        $stmt->execute();
        $entregasDisponiveis = $stmt->fetchAll(PDO::FETCH_ASSOC);
    }
    
    // Ganhos do dia (líquido)
    $stmt = $db->prepare("
        SELECT COALESCE(SUM(valor_liquido), 0) as total
        FROM ganhos_entregadores
        WHERE entregador_id = ? AND DATE(data_pagamento) = CURDATE()
    ");
    $stmt->execute([$entregadorId]);
    $ganhosHoje = $stmt->fetch()['total'];
    
    echo json_encode([
        'success' => true,
        'status' => $status,
        'entregaAtual' => $entregaAtual,
        'entregasDisponiveis' => $entregasDisponiveis,
        'ganhosHoje' => floatval($ganhosHoje)
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao carregar dados']);
}