<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';
require_once '../../config/helpers.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$entregadorId = null;
if (isLoggedIn('entregador')) {
    $entregadorId = getCurrentUserId('entregador');
}

if (!$entregadorId) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    $taxaPercentual = floatval(getConfig('taxa_entregador_percentual', 15));
    
    // Ganhos de hoje
    $stmt = $db->prepare("
        SELECT COALESCE(SUM(valor_liquido), 0) as liquido, COALESCE(SUM(valor_bruto), 0) as bruto,
               COALESCE(SUM(valor_taxa), 0) as taxa, COUNT(*) as qtd
        FROM ganhos_entregadores WHERE entregador_id = ? AND DATE(data_pagamento) = CURDATE()
    ");
    $stmt->execute([$entregadorId]);
    $hoje = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Ganhos da semana
    $stmt = $db->prepare("
        SELECT COALESCE(SUM(valor_liquido), 0) as liquido, COALESCE(SUM(valor_bruto), 0) as bruto, COUNT(*) as qtd
        FROM ganhos_entregadores WHERE entregador_id = ? AND YEARWEEK(data_pagamento) = YEARWEEK(CURDATE())
    ");
    $stmt->execute([$entregadorId]);
    $semana = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Ganhos do mês
    $stmt = $db->prepare("
        SELECT COALESCE(SUM(valor_liquido), 0) as liquido, COALESCE(SUM(valor_bruto), 0) as bruto, COUNT(*) as qtd
        FROM ganhos_entregadores WHERE entregador_id = ? AND MONTH(data_pagamento) = MONTH(CURDATE()) AND YEAR(data_pagamento) = YEAR(CURDATE())
    ");
    $stmt->execute([$entregadorId]);
    $mes = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Por dia (últimos 7 dias)
    $stmt = $db->prepare("
        SELECT DATE(data_pagamento) as dia, SUM(valor_liquido) as liquido, SUM(valor_bruto) as bruto, COUNT(*) as qtd
        FROM ganhos_entregadores WHERE entregador_id = ? AND data_pagamento >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
        GROUP BY DATE(data_pagamento) ORDER BY dia DESC
    ");
    $stmt->execute([$entregadorId]);
    $porDia = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Detalhados (últimas 10)
    $stmt = $db->prepare("
        SELECT g.*, e.origem_endereco, e.destino_endereco, e.updated_at as data_entrega
        FROM ganhos_entregadores g JOIN entregas e ON g.entrega_id = e.id
        WHERE g.entregador_id = ? ORDER BY g.data_pagamento DESC LIMIT 10
    ");
    $stmt->execute([$entregadorId]);
    $detalhados = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'success' => true,
        'taxaPercentual' => $taxaPercentual,
        'hoje' => $hoje,
        'semana' => $semana,
        'mes' => $mes,
        'porDia' => $porDia,
        'detalhados' => $detalhados
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao carregar ganhos']);
}