<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

$entregadorId = null;
if (isLoggedIn('entregador')) {
    $entregadorId = getCurrentUserId('entregador');
}

if (!$entregadorId) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    $stmt = $db->prepare("
        SELECT e.*, u.nome as cliente_nome
        FROM entregas e
        JOIN usuarios u ON e.usuario_id = u.id
        WHERE e.entregador_id = ? AND e.status IN ('entregue', 'cancelada')
        ORDER BY e.updated_at DESC
        LIMIT 50
    ");
    $stmt->execute([$entregadorId]);
    $entregas = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode(['success' => true, 'entregas' => $entregas]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro ao carregar histórico']);
}