<?php
require_once '../../config/database.php';
header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    echo json_encode(['success' => false, 'message' => 'Método não permitido']);
    exit;
}

$email = $_POST['email'] ?? '';
$senha = $_POST['senha'] ?? '';

if (empty($email) || empty($senha)) {
    echo json_encode(['success' => false, 'message' => 'Email e senha são obrigatórios']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    $stmt = $db->prepare("SELECT * FROM entregadores WHERE email = ?");
    $stmt->execute([$email]);
    $entregador = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$entregador || !password_verify($senha, $entregador['senha'])) {
        echo json_encode(['success' => false, 'message' => 'Email ou senha incorretos']);
        exit;
    }
    
    if ($entregador['aprovado'] !== 'aprovado') {
        echo json_encode(['success' => false, 'message' => 'Seu cadastro ainda está em análise']);
        exit;
    }
    
    if (!empty($entregador['bloqueado']) && $entregador['bloqueado'] == 1) {
        echo json_encode(['success' => false, 'message' => 'Sua conta está bloqueada. Entre em contato com o suporte.']);
        exit;
    }
    
    $token = bin2hex(random_bytes(32));
    unset($entregador['senha']);
    
    echo json_encode([
        'success' => true,
        'token' => $token,
        'entregador' => $entregador
    ]);
    
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'Erro no servidor']);
}