/**
 * Gerenciador de Tema - Admin Panel
 */

// Verificar tema salvo ou preferência do sistema
function getPreferredTheme() {
    const saved = localStorage.getItem('admin-theme');
    if (saved) return saved;
    
    // Verificar preferência do sistema
    if (window.matchMedia && window.matchMedia('(prefers-color-scheme: dark)').matches) {
        return 'dark';
    }
    return 'light';
}

// Aplicar tema
function setTheme(theme) {
    document.documentElement.setAttribute('data-theme', theme);
    localStorage.setItem('admin-theme', theme);
    
    // Atualizar ícone do botão
    const btn = document.getElementById('theme-toggle-btn');
    if (btn) {
        btn.textContent = theme === 'dark' ? '☀️' : '🌙';
        btn.title = theme === 'dark' ? 'Mudar para tema claro' : 'Mudar para tema escuro';
    }
}

// Alternar tema
function toggleTheme() {
    const current = document.documentElement.getAttribute('data-theme') || 'light';
    const newTheme = current === 'dark' ? 'light' : 'dark';
    setTheme(newTheme);
}

// Inicializar ao carregar a página
document.addEventListener('DOMContentLoaded', function() {
    setTheme(getPreferredTheme());
});

// Ouvir mudanças na preferência do sistema
if (window.matchMedia) {
    window.matchMedia('(prefers-color-scheme: dark)').addEventListener('change', e => {
        if (!localStorage.getItem('admin-theme')) {
            setTheme(e.matches ? 'dark' : 'light');
        }
    });
}
