<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn('usuario')) {
    echo json_encode(['novas' => []]);
    exit;
}

$db = Database::getInstance()->getConnection();
$usuarioId = getCurrentUserId('usuario');

// Buscar notificações não lidas dos últimos 5 minutos
$stmt = $db->prepare("
    SELECT n.id, n.mensagem, n.tipo, n.entrega_id
    FROM notificacoes_cliente n
    WHERE n.usuario_id = ? 
    AND n.lida = 0 
    AND n.created_at >= DATE_SUB(NOW(), INTERVAL 5 MINUTE)
    ORDER BY n.created_at DESC
");
$stmt->execute([$usuarioId]);
$notificacoes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Marcar como lidas
if (!empty($notificacoes)) {
    $ids = array_column($notificacoes, 'id');
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $stmt = $db->prepare("UPDATE notificacoes_cliente SET lida = 1 WHERE id IN ($placeholders)");
    $stmt->execute($ids);
}

echo json_encode(['novas' => $notificacoes]);
