<?php
session_start();

function isLoggedIn($type = 'usuario') {
    return isset($_SESSION[$type . '_id']);
}

function requireLogin($type = 'usuario', $redirect = '/index.php') {
    if (!isLoggedIn($type)) {
        header("Location: $redirect");
        exit;
    }
}

function login($type, $id, $nome, $email) {
    $_SESSION[$type . '_id'] = $id;
    $_SESSION[$type . '_nome'] = $nome;
    $_SESSION[$type . '_email'] = $email;
}

function logout($type = 'usuario') {
    unset($_SESSION[$type . '_id']);
    unset($_SESSION[$type . '_nome']);
    unset($_SESSION[$type . '_email']);
}

function getCurrentUserId($type = 'usuario') {
    return $_SESSION[$type . '_id'] ?? null;
}

function getCurrentUserName($type = 'usuario') {
    return $_SESSION[$type . '_nome'] ?? null;
}
