<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn('entregador')) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

$status = $_POST['status'] ?? '';
if (!in_array($status, ['disponivel', 'offline'])) {
    echo json_encode(['success' => false, 'message' => 'Status inválido']);
    exit;
}

$db = Database::getInstance()->getConnection();
$stmt = $db->prepare("UPDATE entregadores SET status = ? WHERE id = ?");
$result = $stmt->execute([$status, getCurrentUserId('entregador')]);

echo json_encode(['success' => $result]);
