<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn('entregador')) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

$entregaId = intval($_POST['entrega_id'] ?? 0);
$motivo = trim($_POST['motivo'] ?? '');

if (!$entregaId) {
    echo json_encode(['success' => false, 'message' => 'ID da entrega inválido']);
    exit;
}

if (empty($motivo)) {
    echo json_encode(['success' => false, 'message' => 'Motivo do cancelamento é obrigatório']);
    exit;
}

$db = Database::getInstance()->getConnection();
$entregadorId = getCurrentUserId('entregador');

// Verificar se a entrega pertence ao entregador e está aceita
$stmt = $db->prepare("
    SELECT e.*, u.nome as cliente_nome, u.email as cliente_email 
    FROM entregas e 
    JOIN usuarios u ON e.usuario_id = u.id 
    WHERE e.id = ? AND e.entregador_id = ? AND e.status = 'aceita'
");
$stmt->execute([$entregaId, $entregadorId]);
$entrega = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$entrega) {
    echo json_encode(['success' => false, 'message' => 'Entrega não encontrada ou não pode ser cancelada']);
    exit;
}

try {
    $db->beginTransaction();
    
    // Atualizar entrega para cancelada
    $stmt = $db->prepare("
        UPDATE entregas 
        SET status = 'cancelada', 
            cancelada_por = 'entregador',
            motivo_cancelamento = ?,
            data_cancelamento = NOW()
        WHERE id = ?
    ");
    $stmt->execute([$motivo, $entregaId]);
    
    // Liberar entregador
    $stmt = $db->prepare("UPDATE entregadores SET status = 'disponivel' WHERE id = ?");
    $stmt->execute([$entregadorId]);
    
    // Notificar cliente sobre o cancelamento
    $mensagemCliente = "Sua entrega foi cancelada pelo entregador. Motivo: " . $motivo;
    $stmt = $db->prepare("
        INSERT INTO notificacoes_cliente (usuario_id, entrega_id, tipo, mensagem) 
        VALUES (?, ?, 'cancelada', ?)
    ");
    $stmt->execute([$entrega['usuario_id'], $entregaId, $mensagemCliente]);
    
    $db->commit();
    
    echo json_encode([
        'success' => true, 
        'message' => 'Entrega cancelada com sucesso'
    ]);
    
} catch (Exception $e) {
    $db->rollBack();
    echo json_encode([
        'success' => false, 
        'message' => 'Erro ao cancelar entrega: ' . $e->getMessage()
    ]);
}