<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn('entregador')) {
    echo json_encode(['novas' => [], 'debug' => 'Não logado']);
    exit;
}

$db = Database::getInstance()->getConnection();
$entregadorId = getCurrentUserId('entregador');

// Debug: verificar status do entregador
$stmt = $db->prepare("SELECT status, aprovado FROM entregadores WHERE id = ?");
$stmt->execute([$entregadorId]);
$entregadorInfo = $stmt->fetch(PDO::FETCH_ASSOC);

// Buscar notificações não lidas dos últimos 60 segundos (aumentado para debug)
$stmt = $db->prepare("
    SELECT n.id, n.mensagem, n.entrega_id, e.valor, n.created_at
    FROM notificacoes n
    JOIN entregas e ON n.entrega_id = e.id
    WHERE n.entregador_id = ? 
    AND n.lida = 0 
    AND n.created_at >= DATE_SUB(NOW(), INTERVAL 60 SECOND)
    AND e.status = 'pendente'
    ORDER BY n.created_at DESC
");
$stmt->execute([$entregadorId]);
$notificacoes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Debug: contar total de notificações não lidas
$stmt = $db->prepare("SELECT COUNT(*) as total FROM notificacoes WHERE entregador_id = ? AND lida = 0");
$stmt->execute([$entregadorId]);
$totalNaoLidas = $stmt->fetch()['total'];

// Marcar como lidas
if (!empty($notificacoes)) {
    $ids = array_column($notificacoes, 'id');
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $stmt = $db->prepare("UPDATE notificacoes SET lida = 1 WHERE id IN ($placeholders)");
    $stmt->execute($ids);
}

echo json_encode([
    'novas' => $notificacoes,
    'debug' => [
        'entregador_id' => $entregadorId,
        'status' => $entregadorInfo['status'] ?? 'unknown',
        'aprovado' => $entregadorInfo['aprovado'] ?? 'unknown',
        'total_nao_lidas' => $totalNaoLidas,
        'timestamp' => date('Y-m-d H:i:s')
    ]
]);
