<?php
require_once '../config/database.php';
require_once '../config/auth.php';

if (isLoggedIn('entregador')) {
    header('Location: dashboard.php');
    exit;
}

$erro = '';

// Verificar se há mensagem de bloqueio na sessão
if (isset($_SESSION['erro_bloqueio'])) {
    $erro = $_SESSION['erro_bloqueio'];
    unset($_SESSION['erro_bloqueio']);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $senha = $_POST['senha'] ?? '';
    
    $db = Database::getInstance()->getConnection();
    $stmt = $db->prepare("SELECT id, nome, email, senha, aprovado, bloqueado, motivo_bloqueio FROM entregadores WHERE email = ?");
    $stmt->execute([$email]);
    $entregador = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($entregador && password_verify($senha, $entregador['senha'])) {
        // Verificar se está bloqueado
        if (!empty($entregador['bloqueado']) && $entregador['bloqueado'] == 1) {
            $erro = '🚫 Atenção! Seu acesso à plataforma foi bloqueado temporariamente devido a uma verificação necessária em sua conta. Para entender o motivo e solicitar a liberação, entre em contato com o suporte. Nossa equipe está disponível para orientar você.';
        }
        // Verificar se está aprovado
        elseif ($entregador['aprovado'] === 'pendente') {
            $erro = 'Seu cadastro ainda está em análise. Aguarde a aprovação (até 72h).';
        } elseif ($entregador['aprovado'] === 'rejeitado') {
            $erro = 'Seu cadastro foi rejeitado. Verifique seu email para mais informações.';
        } else {
            login('entregador', $entregador['id'], $entregador['nome'], $entregador['email']);
            
            // Atualizar status para disponível
            $stmt = $db->prepare("UPDATE entregadores SET status = 'disponivel' WHERE id = ?");
            $stmt->execute([$entregador['id']]);
            
            header('Location: dashboard.php');
            exit;
        }
    } else {
        $erro = 'Email ou senha inválidos';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Entregador - Já EntreGo</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/entregador.css">
</head>
<body class="entregador">
    <div class="login-container" style="background: linear-gradient(135deg, #0d47a1 0%, #002171 100%);">
        <div class="login-box">
            <div class="logo">🏍️</div>
            <h2 style="color: #0d47a1;">Área do Entregador</h2>
            
            <?php if ($erro): ?>
                <div class="alert alert-danger" style="<?= strpos($erro, '🚫') !== false ? 'background: #fff3cd; border: 1px solid #ffc107; color: #856404; padding: 15px; line-height: 1.5;' : '' ?>"><?= htmlspecialchars($erro) ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Senha</label>
                    <input type="password" name="senha" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-block" style="background: #0d47a1; color: white;">Entrar</button>
            </form>
            
            <p style="text-align: center; margin-top: 20px; color: #666;">
                Quer ser entregador? <a href="cadastro.php" style="color: #0d47a1;">Cadastre-se</a>
            </p>
            <p style="text-align: center; margin-top: 10px;">
                <a href="../index.php" style="color: #0d47a1;">← Voltar</a>
            </p>
        </div>
    </div>
</body>
</html>
