<?php
/**
 * Instalador Já EntreGo
 * Execute este arquivo para configurar o sistema
 */

$erro = '';
$sucesso = '';
$etapa = $_GET['etapa'] ?? 1;

// Processar instalação
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $host = trim($_POST['host'] ?? 'localhost');
    $dbname = trim($_POST['dbname'] ?? 'entregas_db');
    $user = trim($_POST['user'] ?? 'root');
    $pass = $_POST['pass'] ?? '';
    $admin_email = trim($_POST['admin_email'] ?? 'admin@entregas.com');
    $admin_senha = $_POST['admin_senha'] ?? 'admin123';
    $admin_nome = trim($_POST['admin_nome'] ?? 'Administrador');
    
    try {
        // Conectar ao MySQL (sem selecionar banco)
        $pdo = new PDO("mysql:host=$host;charset=utf8mb4", $user, $pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);
        
        // Criar banco de dados
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$dbname` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        $pdo->exec("USE `$dbname`");
        
        // Criar tabelas uma por uma
        $tabelas = [
            "CREATE TABLE IF NOT EXISTS usuarios (
                id INT AUTO_INCREMENT PRIMARY KEY,
                nome VARCHAR(100) NOT NULL,
                email VARCHAR(100) UNIQUE NOT NULL,
                senha VARCHAR(255) NOT NULL,
                telefone VARCHAR(20),
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )",
            
            "CREATE TABLE IF NOT EXISTS entregadores (
                id INT AUTO_INCREMENT PRIMARY KEY,
                nome VARCHAR(100) NOT NULL,
                email VARCHAR(100) UNIQUE NOT NULL,
                senha VARCHAR(255) NOT NULL,
                telefone VARCHAR(20),
                veiculo ENUM('moto', 'carro', 'bicicleta', 'van') DEFAULT 'moto',
                placa VARCHAR(20),
                status ENUM('disponivel', 'ocupado', 'offline') DEFAULT 'offline',
                latitude DECIMAL(10, 8),
                longitude DECIMAL(11, 8),
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )",
            
            "CREATE TABLE IF NOT EXISTS admins (
                id INT AUTO_INCREMENT PRIMARY KEY,
                nome VARCHAR(100) NOT NULL,
                email VARCHAR(100) UNIQUE NOT NULL,
                senha VARCHAR(255) NOT NULL,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )",
            
            "CREATE TABLE IF NOT EXISTS entregas (
                id INT AUTO_INCREMENT PRIMARY KEY,
                usuario_id INT NOT NULL,
                entregador_id INT,
                origem_endereco VARCHAR(255) NOT NULL,
                origem_lat DECIMAL(10, 8),
                origem_lng DECIMAL(11, 8),
                destino_endereco VARCHAR(255) NOT NULL,
                destino_lat DECIMAL(10, 8),
                destino_lng DECIMAL(11, 8),
                descricao TEXT,
                valor DECIMAL(10, 2) NOT NULL,
                status ENUM('pendente', 'aceita', 'coletada', 'entregue', 'cancelada') DEFAULT 'pendente',
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            )",
            
            "CREATE TABLE IF NOT EXISTS notificacoes (
                id INT AUTO_INCREMENT PRIMARY KEY,
                entregador_id INT,
                entrega_id INT,
                mensagem VARCHAR(255),
                lida TINYINT(1) DEFAULT 0,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )",
            
            "CREATE TABLE IF NOT EXISTS notificacoes_cliente (
                id INT AUTO_INCREMENT PRIMARY KEY,
                usuario_id INT NOT NULL,
                entrega_id INT NOT NULL,
                tipo ENUM('aceita', 'coletada', 'entregue') NOT NULL,
                mensagem VARCHAR(255),
                lida TINYINT(1) DEFAULT 0,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )",
            
            "CREATE TABLE IF NOT EXISTS configuracoes (
                id INT AUTO_INCREMENT PRIMARY KEY,
                chave VARCHAR(50) UNIQUE NOT NULL,
                valor TEXT,
                descricao VARCHAR(255),
                updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
            )",
            
            "CREATE TABLE IF NOT EXISTS empresas_parceiras (
                id INT AUTO_INCREMENT PRIMARY KEY,
                nome_empresa VARCHAR(100) NOT NULL,
                cnpj VARCHAR(20) UNIQUE,
                email VARCHAR(100) NOT NULL,
                telefone VARCHAR(20),
                endereco VARCHAR(255),
                responsavel VARCHAR(100),
                status ENUM('pendente', 'aprovada', 'rejeitada') DEFAULT 'pendente',
                observacoes TEXT,
                created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
            )"
        ];
        
        // Executar cada CREATE TABLE
        foreach ($tabelas as $sql) {
            $pdo->exec($sql);
        }
        
        // Inserir configurações padrão
        $configs = [
            ['nome_empresa', 'Já EntreGo', 'Nome da empresa exibido nos apps'],
            ['email_empresa', 'contato@jaentrego.com', 'Email de contato da empresa'],
            ['telefone_empresa', '', 'Telefone de contato da empresa'],
            ['endereco_empresa', '', 'Endereço da empresa'],
            ['taxa_entregador_percentual', '15', 'Taxa percentual cobrada do entregador por entrega (%)'],
            ['taxa_entregador_fixa', '0', 'Taxa fixa cobrada do entregador por entrega (R$)'],
            ['valor_minimo_entrega', '10', 'Valor mínimo de uma entrega (R$)'],
            ['valor_por_km', '2.50', 'Valor cobrado por km rodado (R$)']
        ];
        
        foreach ($configs as $cfg) {
            $stmt = $pdo->prepare("INSERT IGNORE INTO configuracoes (chave, valor, descricao) VALUES (?, ?, ?)");
            $stmt->execute($cfg);
        }
        
        // Criar ou atualizar admin
        $senhaHash = password_hash($admin_senha, PASSWORD_DEFAULT);
        
        $stmt = $pdo->prepare("SELECT id FROM admins WHERE email = ?");
        $stmt->execute([$admin_email]);
        
        if ($stmt->fetch()) {
            $stmt = $pdo->prepare("UPDATE admins SET nome = ?, senha = ? WHERE email = ?");
            $stmt->execute([$admin_nome, $senhaHash, $admin_email]);
        } else {
            $stmt = $pdo->prepare("INSERT INTO admins (nome, email, senha) VALUES (?, ?, ?)");
            $stmt->execute([$admin_nome, $admin_email, $senhaHash]);
        }
        
        // Atualizar arquivo de configuração
        $configContent = "<?php
// Configuração do banco de dados
define('DB_HOST', '$host');
define('DB_NAME', '$dbname');
define('DB_USER', '$user');
define('DB_PASS', '$pass');

class Database {
    private static \$instance = null;
    private \$conn;

    private function __construct() {
        try {
            \$this->conn = new PDO(
                \"mysql:host=\" . DB_HOST . \";dbname=\" . DB_NAME . \";charset=utf8mb4\",
                DB_USER,
                DB_PASS,
                [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
            );
        } catch (PDOException \$e) {
            die(\"Erro de conexão: \" . \$e->getMessage());
        }
    }

    public static function getInstance() {
        if (self::\$instance === null) {
            self::\$instance = new self();
        }
        return self::\$instance;
    }

    public function getConnection() {
        return \$this->conn;
    }
}
";
        file_put_contents('config/database.php', $configContent);
        
        $sucesso = 'Instalação concluída com sucesso!';
        $etapa = 3;
        
    } catch (PDOException $e) {
        $erro = 'Erro: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalador - Já EntreGo</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #1a73e8 0%, #0d47a1 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        .container {
            background: white;
            border-radius: 16px;
            padding: 40px;
            width: 100%;
            max-width: 500px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.2);
        }
        .logo {
            text-align: center;
            font-size: 60px;
            margin-bottom: 10px;
        }
        h1 {
            text-align: center;
            color: #1a73e8;
            margin-bottom: 10px;
        }
        .subtitle {
            text-align: center;
            color: #666;
            margin-bottom: 30px;
        }
        .steps {
            display: flex;
            justify-content: center;
            gap: 10px;
            margin-bottom: 30px;
        }
        .step {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: #e0e0e0;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            color: #999;
        }
        .step.active {
            background: #1a73e8;
            color: white;
        }
        .step.done {
            background: #4caf50;
            color: white;
        }
        .form-group {
            margin-bottom: 20px;
        }
        .form-group label {
            display: block;
            margin-bottom: 6px;
            font-weight: 500;
            color: #333;
        }
        .form-group small {
            color: #999;
            font-size: 12px;
        }
        .form-control {
            width: 100%;
            padding: 12px 16px;
            border: 2px solid #e0e0e0;
            border-radius: 8px;
            font-size: 16px;
            transition: border-color 0.3s;
        }
        .form-control:focus {
            outline: none;
            border-color: #1a73e8;
        }
        .btn {
            width: 100%;
            padding: 14px;
            background: #1a73e8;
            color: white;
            border: none;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.3s;
        }
        .btn:hover {
            background: #1557b0;
        }
        .btn-success {
            background: #4caf50;
        }
        .btn-success:hover {
            background: #388e3c;
        }
        .alert {
            padding: 12px 16px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .alert-danger {
            background: #ffebee;
            color: #c62828;
            border: 1px solid #ef9a9a;
        }
        .alert-success {
            background: #e8f5e9;
            color: #2e7d32;
            border: 1px solid #a5d6a7;
        }
        .section-title {
            font-size: 14px;
            color: #1a73e8;
            text-transform: uppercase;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e0e0e0;
        }
        .success-icon {
            text-align: center;
            font-size: 80px;
            margin-bottom: 20px;
        }
        .links {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #e0e0e0;
        }
        .links a {
            display: block;
            padding: 12px;
            margin-bottom: 10px;
            background: #f5f5f5;
            border-radius: 8px;
            text-decoration: none;
            color: #333;
            text-align: center;
            transition: background 0.3s;
        }
        .links a:hover {
            background: #e0e0e0;
        }
        .warning {
            background: #fff3e0;
            border: 1px solid #ffcc80;
            color: #e65100;
            padding: 12px;
            border-radius: 8px;
            margin-top: 20px;
            font-size: 14px;
        }
        .req-list {
            background: #f5f5f5;
            padding: 20px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        .req-item {
            display: flex;
            align-items: center;
            gap: 10px;
            margin-bottom: 10px;
        }
        .req-item:last-child {
            margin-bottom: 0;
        }
        .req-icon {
            font-size: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="logo">🚚</div>
        <h1>Já EntreGo</h1>
        <p class="subtitle">Assistente de Instalação</p>
        
        <div class="steps">
            <div class="step <?= $etapa >= 1 ? ($etapa > 1 ? 'done' : 'active') : '' ?>">1</div>
            <div class="step <?= $etapa >= 2 ? ($etapa > 2 ? 'done' : 'active') : '' ?>">2</div>
            <div class="step <?= $etapa >= 3 ? 'done' : '' ?>">3</div>
        </div>
        
        <?php if ($erro): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>
        
        <?php if ($etapa == 1): ?>
            <!-- Etapa 1: Requisitos -->
            <h3 class="section-title">Verificação de Requisitos</h3>
            
            <div class="req-list">
                <div class="req-item">
                    <span class="req-icon"><?= version_compare(PHP_VERSION, '7.4.0', '>=') ? '✅' : '❌' ?></span>
                    <span>PHP 7.4 ou superior (atual: <?= PHP_VERSION ?>)</span>
                </div>
                <div class="req-item">
                    <span class="req-icon"><?= extension_loaded('pdo_mysql') ? '✅' : '❌' ?></span>
                    <span>Extensão PDO MySQL</span>
                </div>
                <div class="req-item">
                    <span class="req-icon"><?= is_writable('config/') ? '✅' : '❌' ?></span>
                    <span>Pasta config/ com permissão de escrita</span>
                </div>
            </div>
            
            <?php 
            $requisitosOk = version_compare(PHP_VERSION, '7.4.0', '>=') 
                         && extension_loaded('pdo_mysql') 
                         && is_writable('config/');
            ?>
            
            <?php if ($requisitosOk): ?>
                <a href="?etapa=2" class="btn">Continuar →</a>
            <?php else: ?>
                <div class="alert alert-danger">Corrija os requisitos acima antes de continuar.</div>
            <?php endif; ?>
            
        <?php elseif ($etapa == 2): ?>
            <!-- Etapa 2: Configuração -->
            <form method="POST">
                <h3 class="section-title">Banco de Dados MySQL</h3>
                
                <div class="form-group">
                    <label>Host</label>
                    <input type="text" name="host" class="form-control" value="localhost" required>
                </div>
                
                <div class="form-group">
                    <label>Nome do Banco</label>
                    <input type="text" name="dbname" class="form-control" value="entregas_db" required>
                    <small>Será criado automaticamente se não existir</small>
                </div>
                
                <div class="form-group">
                    <label>Usuário</label>
                    <input type="text" name="user" class="form-control" value="root" required>
                </div>
                
                <div class="form-group">
                    <label>Senha</label>
                    <input type="password" name="pass" class="form-control">
                    <small>Deixe em branco se não tiver senha</small>
                </div>
                
                <h3 class="section-title" style="margin-top: 30px;">Conta do Administrador</h3>
                
                <div class="form-group">
                    <label>Nome</label>
                    <input type="text" name="admin_nome" class="form-control" value="Administrador" required>
                </div>
                
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="admin_email" class="form-control" value="admin@entregas.com" required>
                </div>
                
                <div class="form-group">
                    <label>Senha</label>
                    <input type="password" name="admin_senha" class="form-control" value="admin123" required>
                    <small>Mínimo 6 caracteres</small>
                </div>
                
                <button type="submit" class="btn">Instalar 🚀</button>
            </form>
            
        <?php elseif ($etapa == 3): ?>
            <!-- Etapa 3: Sucesso -->
            <div class="success-icon">✅</div>
            <div class="alert alert-success">
                <strong>Instalação concluída!</strong><br>
                O sistema está pronto para uso.
            </div>
            
            <div class="links">
                <a href="index.php">🛒 Área do Cliente</a>
                <a href="entregador/">🏍️ App do Entregador</a>
                <a href="admin/">⚙️ Painel Administrativo</a>
            </div>
            
            <div class="warning">
                <strong>⚠️ Importante:</strong> Por segurança, delete este arquivo (instalar.php) após a instalação!
            </div>
        <?php endif; ?>
    </div>
</body>
</html>
