<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Já EntreGo - Entregas Rápidas e Seguras</title>
    <meta name="description" content="A melhor plataforma de entregas da sua região. Envie pacotes com rapidez, segurança e preços justos.">
    
    <!-- PWA Meta Tags -->
    <meta name="theme-color" content="#1a73e8">
    <meta name="apple-mobile-web-app-capable" content="yes">
    <meta name="apple-mobile-web-app-status-bar-style" content="black-translucent">
    <meta name="apple-mobile-web-app-title" content="Já EntreGo">
    <link rel="manifest" href="manifest.json">
    <link rel="apple-touch-icon" href="assets/icons/icon-192.png">
    
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: 'Poppins', sans-serif; background: #fff; color: #333; overflow-x: hidden; }
        
        /* Navbar */
        .navbar { position: fixed; top: 0; left: 0; right: 0; z-index: 1000; padding: 15px 5%; display: flex; justify-content: space-between; align-items: center; transition: all 0.3s; }
        .navbar.scrolled { background: rgba(255,255,255,0.98); box-shadow: 0 2px 20px rgba(0,0,0,0.1); }
        .navbar .logo { font-size: 28px; font-weight: 800; color: #1a73e8; text-decoration: none; }
        .navbar .logo span { color: #f57c00; }
        .nav-links { display: flex; gap: 30px; align-items: center; }
        .nav-links a { text-decoration: none; color: #333; font-weight: 500; transition: color 0.3s; }
        .nav-links a:hover { color: #1a73e8; }
        .btn-nav { background: #1a73e8; color: #fff !important; padding: 12px 28px; border-radius: 30px; }
        .btn-nav:hover { background: #0d5bbd; }
        
        /* Hero Section */
        .hero { min-height: 100vh; background: linear-gradient(135deg, #667eea 0%, #764ba2 50%, #f093fb 100%); display: flex; align-items: center; padding: 100px 5% 60px; position: relative; overflow: hidden; }
        .hero::before { content: ''; position: absolute; top: -50%; right: -20%; width: 80%; height: 200%; background: radial-gradient(circle, rgba(255,255,255,0.1) 0%, transparent 70%); }
        .hero-content { flex: 1; z-index: 2; max-width: 600px; }
        .hero-badge { display: inline-block; background: rgba(255,255,255,0.2); color: #fff; padding: 8px 20px; border-radius: 30px; font-size: 14px; margin-bottom: 20px; backdrop-filter: blur(10px); }
        .hero h1 { font-size: 56px; font-weight: 800; color: #fff; line-height: 1.1; margin-bottom: 20px; }
        .hero h1 span { color: #ffd54f; }
        .hero p { font-size: 20px; color: rgba(255,255,255,0.9); margin-bottom: 35px; line-height: 1.6; }
        .hero-buttons { display: flex; gap: 15px; flex-wrap: wrap; }
        .btn-hero { padding: 16px 36px; border-radius: 50px; font-size: 16px; font-weight: 600; text-decoration: none; transition: all 0.3s; display: inline-flex; align-items: center; gap: 10px; }
        .btn-primary { background: #fff; color: #764ba2; }
        .btn-primary:hover { transform: translateY(-3px); box-shadow: 0 10px 30px rgba(0,0,0,0.2); }
        .btn-secondary { background: transparent; color: #fff; border: 2px solid rgba(255,255,255,0.5); }
        .btn-secondary:hover { background: rgba(255,255,255,0.1); border-color: #fff; }
        
        /* Hero Phone Mockup */
        .hero-image { flex: 1; display: flex; justify-content: center; align-items: center; z-index: 2; }
        .phone-mockup { position: relative; }
        .phone-frame { width: 280px; height: 580px; background: #1a1a2e; border-radius: 40px; padding: 10px; box-shadow: 0 50px 100px rgba(0,0,0,0.3); position: relative; z-index: 2; }
        .phone-screen { width: 100%; height: 100%; background: linear-gradient(180deg, #1a73e8 0%, #0d47a1 100%); border-radius: 32px; overflow: hidden; display: flex; flex-direction: column; align-items: center; padding: 40px 20px; }
        .phone-screen .app-logo { font-size: 40px; margin-bottom: 10px; }
        .phone-screen .app-name { color: #fff; font-size: 24px; font-weight: 700; margin-bottom: 30px; }
        .phone-screen .app-card { background: #fff; width: 100%; border-radius: 16px; padding: 20px; margin-bottom: 15px; }
        .phone-screen .app-card .label { font-size: 12px; color: #999; }
        .phone-screen .app-card .value { font-size: 14px; color: #333; font-weight: 500; }
        .phone-screen .app-btn { background: #f57c00; color: #fff; width: 100%; padding: 15px; border-radius: 12px; text-align: center; font-weight: 600; margin-top: auto; }
        .phone-float { position: absolute; width: 220px; height: 460px; background: #1a1a2e; border-radius: 30px; padding: 8px; box-shadow: 0 30px 60px rgba(0,0,0,0.2); }
        .phone-float.left { left: -100px; top: 60px; transform: rotate(-15deg); z-index: 1; }
        .phone-float.right { right: -100px; top: 80px; transform: rotate(15deg); z-index: 1; }
        .phone-float .screen { width: 100%; height: 100%; background: linear-gradient(180deg, #0d47a1 0%, #1565c0 100%); border-radius: 24px; }
        
        /* Stats */
        .stats-bar { background: #fff; padding: 40px 5%; display: flex; justify-content: center; gap: 80px; flex-wrap: wrap; box-shadow: 0 10px 40px rgba(0,0,0,0.08); position: relative; z-index: 10; margin-top: -40px; border-radius: 20px; max-width: 1000px; margin-left: auto; margin-right: auto; }
        .stat-item { text-align: center; }
        .stat-number { font-size: 42px; font-weight: 800; color: #1a73e8; }
        .stat-label { font-size: 14px; color: #666; margin-top: 5px; }
        
        /* Features */
        .features { padding: 100px 5%; background: #f8fafc; }
        .section-header { text-align: center; max-width: 600px; margin: 0 auto 60px; }
        .section-header h2 { font-size: 42px; font-weight: 700; color: #1a1a2e; margin-bottom: 15px; }
        .section-header p { font-size: 18px; color: #666; }
        .features-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(280px, 1fr)); gap: 30px; max-width: 1200px; margin: 0 auto; }
        .feature-card { background: #fff; padding: 40px 30px; border-radius: 20px; text-align: center; transition: all 0.3s; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        .feature-card:hover { transform: translateY(-10px); box-shadow: 0 20px 40px rgba(0,0,0,0.1); }
        .feature-icon { width: 80px; height: 80px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 20px; display: flex; align-items: center; justify-content: center; font-size: 36px; margin: 0 auto 25px; }
        .feature-card h3 { font-size: 22px; font-weight: 600; margin-bottom: 12px; color: #1a1a2e; }
        .feature-card p { font-size: 15px; color: #666; line-height: 1.7; }
        
        /* How it Works */
        .how-it-works { padding: 100px 5%; background: #fff; }
        .steps-container { display: flex; justify-content: center; gap: 40px; flex-wrap: wrap; max-width: 1200px; margin: 0 auto; }
        .step { flex: 1; min-width: 250px; max-width: 300px; text-align: center; position: relative; }
        .step-number { width: 60px; height: 60px; background: linear-gradient(135deg, #f57c00 0%, #ff9800 100%); color: #fff; border-radius: 50%; display: flex; align-items: center; justify-content: center; font-size: 24px; font-weight: 700; margin: 0 auto 20px; }
        .step h3 { font-size: 20px; font-weight: 600; margin-bottom: 10px; color: #1a1a2e; }
        .step p { font-size: 15px; color: #666; }
        .step-line { position: absolute; top: 30px; left: 60%; width: 80%; height: 2px; background: linear-gradient(90deg, #f57c00, transparent); }
        .step:last-child .step-line { display: none; }
        
        /* Download Section */
        .download-section { padding: 100px 5%; background: linear-gradient(135deg, #1a1a2e 0%, #2d2d44 100%); position: relative; overflow: hidden; }
        .download-section::before { content: ''; position: absolute; top: 0; left: 0; right: 0; bottom: 0; background: url("data:image/svg+xml,%3Csvg width='60' height='60' viewBox='0 0 60 60' xmlns='http://www.w3.org/2000/svg'%3E%3Cg fill='none' fill-rule='evenodd'%3E%3Cg fill='%23ffffff' fill-opacity='0.03'%3E%3Cpath d='M36 34v-4h-2v4h-4v2h4v4h2v-4h4v-2h-4zm0-30V0h-2v4h-4v2h4v4h2V6h4V4h-4zM6 34v-4H4v4H0v2h4v4h2v-4h4v-2H6zM6 4V0H4v4H0v2h4v4h2V6h4V4H6z'/%3E%3C/g%3E%3C/g%3E%3C/svg%3E"); }
        .download-content { display: flex; align-items: center; justify-content: space-between; max-width: 1200px; margin: 0 auto; position: relative; z-index: 2; flex-wrap: wrap; gap: 60px; }
        .download-text { flex: 1; min-width: 300px; }
        .download-text h2 { font-size: 42px; font-weight: 700; color: #fff; margin-bottom: 20px; line-height: 1.2; }
        .download-text p { font-size: 18px; color: rgba(255,255,255,0.7); margin-bottom: 35px; line-height: 1.7; }
        .store-buttons { display: flex; gap: 15px; flex-wrap: wrap; }
        .store-btn { display: flex; align-items: center; gap: 12px; background: #fff; padding: 12px 24px; border-radius: 12px; text-decoration: none; transition: all 0.3s; }
        .store-btn:hover { transform: translateY(-3px); box-shadow: 0 10px 30px rgba(0,0,0,0.3); }
        .store-btn .icon { font-size: 32px; }
        .store-btn .text { text-align: left; }
        .store-btn .text .small { font-size: 11px; color: #666; }
        .store-btn .text .big { font-size: 18px; font-weight: 600; color: #1a1a2e; }
        .download-phones { flex: 1; min-width: 300px; display: flex; justify-content: center; position: relative; }
        .download-phones .phone { width: 240px; height: 500px; background: #000; border-radius: 35px; padding: 8px; box-shadow: 0 30px 60px rgba(0,0,0,0.4); }
        .download-phones .phone .screen { width: 100%; height: 100%; background: linear-gradient(180deg, #1a73e8 0%, #0d47a1 100%); border-radius: 28px; display: flex; flex-direction: column; align-items: center; justify-content: center; }
        .download-phones .phone .screen .emoji { font-size: 60px; margin-bottom: 15px; }
        .download-phones .phone .screen .txt { color: #fff; font-size: 18px; font-weight: 600; }
        .download-phones .phone:nth-child(2) { position: absolute; left: 50%; transform: translateX(-50%) scale(0.85); z-index: -1; opacity: 0.7; }
        
        /* Testimonials */
        .testimonials { padding: 100px 5%; background: #f8fafc; }
        .testimonials-grid { display: grid; grid-template-columns: repeat(auto-fit, minmax(320px, 1fr)); gap: 30px; max-width: 1200px; margin: 0 auto; }
        .testimonial-card { background: #fff; padding: 35px; border-radius: 20px; box-shadow: 0 5px 20px rgba(0,0,0,0.05); }
        .testimonial-card .stars { color: #ffc107; font-size: 20px; margin-bottom: 15px; }
        .testimonial-card .text { font-size: 16px; color: #555; line-height: 1.7; margin-bottom: 20px; font-style: italic; }
        .testimonial-card .author { display: flex; align-items: center; gap: 15px; }
        .testimonial-card .avatar { width: 50px; height: 50px; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); border-radius: 50%; display: flex; align-items: center; justify-content: center; color: #fff; font-weight: 600; font-size: 18px; }
        .testimonial-card .author-info .name { font-weight: 600; color: #1a1a2e; }
        .testimonial-card .author-info .role { font-size: 13px; color: #999; }
        
        /* CTA Section */
        .cta-section { padding: 100px 5%; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); text-align: center; }
        .cta-section h2 { font-size: 42px; font-weight: 700; color: #fff; margin-bottom: 20px; }
        .cta-section p { font-size: 18px; color: rgba(255,255,255,0.9); margin-bottom: 35px; max-width: 600px; margin-left: auto; margin-right: auto; }
        .cta-buttons { display: flex; justify-content: center; gap: 20px; flex-wrap: wrap; }
        .btn-cta { padding: 18px 40px; border-radius: 50px; font-size: 16px; font-weight: 600; text-decoration: none; transition: all 0.3s; }
        .btn-cta.primary { background: #fff; color: #764ba2; }
        .btn-cta.secondary { background: transparent; color: #fff; border: 2px solid #fff; }
        .btn-cta:hover { transform: translateY(-3px); box-shadow: 0 10px 30px rgba(0,0,0,0.2); }
        
        /* Footer */
        .footer { background: #1a1a2e; color: #fff; padding: 60px 5% 30px; }
        .footer-content { display: flex; justify-content: space-between; flex-wrap: wrap; gap: 40px; max-width: 1200px; margin: 0 auto; }
        .footer-brand { max-width: 300px; }
        .footer-brand .logo { font-size: 28px; font-weight: 800; color: #fff; margin-bottom: 15px; }
        .footer-brand .logo span { color: #f57c00; }
        .footer-brand p { font-size: 14px; color: rgba(255,255,255,0.6); line-height: 1.7; }
        .footer-links h4 { font-size: 16px; font-weight: 600; margin-bottom: 20px; }
        .footer-links a { display: block; color: rgba(255,255,255,0.6); text-decoration: none; margin-bottom: 10px; font-size: 14px; transition: color 0.3s; }
        .footer-links a:hover { color: #fff; }
        .footer-bottom { border-top: 1px solid rgba(255,255,255,0.1); margin-top: 40px; padding-top: 20px; text-align: center; font-size: 14px; color: rgba(255,255,255,0.5); }
        
        /* Animations */
        @keyframes float { 0%, 100% { transform: translateY(0); } 50% { transform: translateY(-20px); } }
        .float-animation { animation: float 6s ease-in-out infinite; }
        
        /* Responsive */
        @media (max-width: 768px) {
            .navbar { padding: 15px 20px; }
            .nav-links { display: none; }
            .hero { flex-direction: column; text-align: center; padding-top: 120px; }
            .hero h1 { font-size: 36px; }
            .hero p { font-size: 16px; }
            .hero-buttons { justify-content: center; }
            .hero-image { margin-top: 50px; }
            .phone-float { display: none; }
            .phone-frame { width: 240px; height: 500px; }
            .stats-bar { gap: 30px; padding: 30px 20px; margin: -30px 20px 0; }
            .stat-number { font-size: 32px; }
            .section-header h2 { font-size: 32px; }
            .download-text h2 { font-size: 32px; }
            .cta-section h2 { font-size: 32px; }
            .step-line { display: none; }
        }
    </style>
</head>
<body>

    <!-- Navbar -->
    <nav class="navbar" id="navbar">
        <a href="#" class="logo">Já Entre<span>Go</span></a>
        <div class="nav-links">
            <a href="#features">Recursos</a>
            <a href="#how-it-works">Como Funciona</a>
            <a href="#download">Baixar App</a>
            <a href="index.php" class="btn-nav">Entrar</a>
        </div>
    </nav>
    
    <!-- Hero Section -->
    <section class="hero">
        <div class="hero-content">
            <div class="hero-badge">🚀 A revolução das entregas chegou!</div>
            <h1>Entregas <span>rápidas</span> na palma da sua mão</h1>
            <p>Envie pacotes para qualquer lugar da cidade com segurança, rastreamento em tempo real e os melhores preços. Simples assim!</p>
            <div class="hero-buttons">
                <a href="cadastro.php" class="btn-hero btn-primary">
                    <span>📦</span> Começar Agora
                </a>
                <a href="#download" class="btn-hero btn-secondary">
                    <span>📱</span> Baixar App
                </a>
            </div>
        </div>
        <div class="hero-image">
            <div class="phone-mockup float-animation">
                <div class="phone-float left">
                    <div class="screen"></div>
                </div>
                <div class="phone-frame">
                    <div class="phone-screen">
                        <div class="app-logo">🚚</div>
                        <div class="app-name">Já EntreGo</div>
                        <div class="app-card">
                            <div class="label">📍 Coleta</div>
                            <div class="value">Av. Paulista, 1000</div>
                        </div>
                        <div class="app-card">
                            <div class="label">🎯 Entrega</div>
                            <div class="value">Rua Augusta, 500</div>
                        </div>
                        <div class="app-btn">Solicitar Entrega</div>
                    </div>
                </div>
                <div class="phone-float right">
                    <div class="screen"></div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Stats Bar -->
    <div class="stats-bar">
        <div class="stat-item">
            <div class="stat-number">50K+</div>
            <div class="stat-label">Entregas Realizadas</div>
        </div>
        <div class="stat-item">
            <div class="stat-number">10K+</div>
            <div class="stat-label">Clientes Satisfeitos</div>
        </div>
        <div class="stat-item">
            <div class="stat-number">500+</div>
            <div class="stat-label">Entregadores Ativos</div>
        </div>
        <div class="stat-item">
            <div class="stat-number">4.9</div>
            <div class="stat-label">Avaliação Média</div>
        </div>
    </div>

    <!-- Features Section -->
    <section class="features" id="features">
        <div class="section-header">
            <h2>Por que escolher o Já EntreGo?</h2>
            <p>Oferecemos a melhor experiência em entregas com tecnologia de ponta e preços justos</p>
        </div>
        <div class="features-grid">
            <div class="feature-card">
                <div class="feature-icon">⚡</div>
                <h3>Super Rápido</h3>
                <p>Entregas em minutos! Nossos entregadores estão sempre prontos para coletar seu pacote.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon">📍</div>
                <h3>Rastreamento Real</h3>
                <p>Acompanhe sua entrega em tempo real no mapa. Saiba exatamente onde está seu pacote.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon">💰</div>
                <h3>Preços Justos</h3>
                <p>Valores transparentes calculados por km. Sem surpresas, você sabe quanto vai pagar antes.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon">🛡️</div>
                <h3>100% Seguro</h3>
                <p>Entregadores verificados e avaliados. Seu pacote está em boas mãos.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon">🏍️</div>
                <h3>Vários Veículos</h3>
                <p>Moto, carro, van ou caminhão. Escolha o veículo ideal para sua entrega.</p>
            </div>
            <div class="feature-card">
                <div class="feature-icon">💬</div>
                <h3>Suporte 24h</h3>
                <p>Nossa equipe está sempre disponível para ajudar você com qualquer dúvida.</p>
            </div>
        </div>
    </section>
    
    <!-- How it Works -->
    <section class="how-it-works" id="how-it-works">
        <div class="section-header">
            <h2>Como Funciona?</h2>
            <p>Em apenas 3 passos simples você solicita sua entrega</p>
        </div>
        <div class="steps-container">
            <div class="step">
                <div class="step-number">1</div>
                <h3>Informe os Endereços</h3>
                <p>Digite o local de coleta e entrega. Use sua localização atual ou digite o endereço.</p>
                <div class="step-line"></div>
            </div>
            <div class="step">
                <div class="step-number">2</div>
                <h3>Escolha o Veículo</h3>
                <p>Selecione entre moto, carro, van ou caminhão. Veja o preço antes de confirmar.</p>
                <div class="step-line"></div>
            </div>
            <div class="step">
                <div class="step-number">3</div>
                <h3>Acompanhe a Entrega</h3>
                <p>Um entregador aceita seu pedido e você acompanha tudo em tempo real!</p>
            </div>
        </div>
    </section>

    <!-- Download Section -->
    <section class="download-section" id="download">
        <div class="download-content">
            <div class="download-text">
                <h2>Baixe o App Agora e Ganhe sua Primeira Entrega Grátis!</h2>
                <p>Disponível para Android e iOS. Instale agora e comece a enviar seus pacotes com a melhor plataforma de entregas da região.</p>
                <div class="store-buttons">
                    <a href="#" class="store-btn" id="btnInstallApp">
                        <div class="icon">📱</div>
                        <div class="text">
                            <div class="small">Instalar</div>
                            <div class="big">Web App</div>
                        </div>
                    </a>
                    <a href="#" class="store-btn">
                        <div class="icon">🤖</div>
                        <div class="text">
                            <div class="small">Disponível no</div>
                            <div class="big">Google Play</div>
                        </div>
                    </a>
                    <a href="#" class="store-btn">
                        <div class="icon">🍎</div>
                        <div class="text">
                            <div class="small">Disponível na</div>
                            <div class="big">App Store</div>
                        </div>
                    </a>
                </div>
            </div>
            <div class="download-phones">
                <div class="phone">
                    <div class="screen">
                        <div class="emoji">🚚</div>
                        <div class="txt">Já EntreGo</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- Testimonials -->
    <section class="testimonials">
        <div class="section-header">
            <h2>O que nossos clientes dizem</h2>
            <p>Milhares de pessoas já confiam no Já EntreGo</p>
        </div>
        <div class="testimonials-grid">
            <div class="testimonial-card">
                <div class="stars">⭐⭐⭐⭐⭐</div>
                <div class="text">"Incrível! Pedi uma entrega e em 20 minutos já estava no destino. O app é muito fácil de usar e o preço é justo. Recomendo!"</div>
                <div class="author">
                    <div class="avatar">M</div>
                    <div class="author-info">
                        <div class="name">Maria Silva</div>
                        <div class="role">Empresária</div>
                    </div>
                </div>
            </div>
            <div class="testimonial-card">
                <div class="stars">⭐⭐⭐⭐⭐</div>
                <div class="text">"Uso todos os dias para enviar documentos da minha empresa. Nunca tive problemas, sempre pontual e seguro. Melhor app de entregas!"</div>
                <div class="author">
                    <div class="avatar">J</div>
                    <div class="author-info">
                        <div class="name">João Santos</div>
                        <div class="role">Advogado</div>
                    </div>
                </div>
            </div>
            <div class="testimonial-card">
                <div class="stars">⭐⭐⭐⭐⭐</div>
                <div class="text">"O rastreamento em tempo real é sensacional! Consigo ver exatamente onde está meu pacote. Atendimento nota 10!"</div>
                <div class="author">
                    <div class="avatar">A</div>
                    <div class="author-info">
                        <div class="name">Ana Costa</div>
                        <div class="role">Designer</div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <!-- CTA Section -->
    <section class="cta-section">
        <h2>Pronto para começar?</h2>
        <p>Cadastre-se agora e faça sua primeira entrega em minutos. É rápido, fácil e seguro!</p>
        <div class="cta-buttons">
            <a href="cadastro.php" class="btn-cta primary">Criar Conta Grátis</a>
            <a href="entregador/cadastro.php" class="btn-cta secondary">Quero ser Entregador</a>
        </div>
    </section>
    
    <!-- Footer -->
    <footer class="footer">
        <div class="footer-content">
            <div class="footer-brand">
                <div class="logo">Já Entre<span>Go</span></div>
                <p>A plataforma de entregas mais rápida e segura da sua região. Conectando pessoas e negócios.</p>
            </div>
            <div class="footer-links">
                <h4>Links Rápidos</h4>
                <a href="index.php">Login Cliente</a>
                <a href="entregador/index.php">Login Entregador</a>
                <a href="cadastro.php">Cadastro</a>
                <a href="parceiro.php">Seja Parceiro</a>
            </div>
            <div class="footer-links">
                <h4>Suporte</h4>
                <a href="#">Central de Ajuda</a>
                <a href="#">Termos de Uso</a>
                <a href="#">Política de Privacidade</a>
                <a href="#">Contato</a>
            </div>
            <div class="footer-links">
                <h4>Contato</h4>
                <a href="#">📧 contato@jaentrego.com</a>
                <a href="#">📱 (11) 99999-9999</a>
                <a href="#">📍 São Paulo, SP</a>
            </div>
        </div>
        <div class="footer-bottom">
            <p>&copy; 2024 Já EntreGo. Todos os direitos reservados.</p>
        </div>
    </footer>
    
    <script>
    // Navbar scroll effect
    window.addEventListener('scroll', function() {
        const navbar = document.getElementById('navbar');
        if (window.scrollY > 50) {
            navbar.classList.add('scrolled');
        } else {
            navbar.classList.remove('scrolled');
        }
    });
    
    // Smooth scroll
    document.querySelectorAll('a[href^="#"]').forEach(anchor => {
        anchor.addEventListener('click', function(e) {
            e.preventDefault();
            const target = document.querySelector(this.getAttribute('href'));
            if (target) {
                target.scrollIntoView({ behavior: 'smooth', block: 'start' });
            }
        });
    });
    
    // Install button click
    document.getElementById('btnInstallApp').addEventListener('click', function(e) {
        e.preventDefault();
        if (typeof installPWA === 'function') {
            installPWA();
        } else {
            alert('Para instalar, use o menu do navegador > "Adicionar à tela inicial"');
        }
    });
    </script>
    
    <!-- PWA Script -->
    <script src="assets/js/pwa.js"></script>
</body>
</html>
