import React from 'react';
import { NavigationContainer } from '@react-navigation/native';
import { createNativeStackNavigator } from '@react-navigation/native-stack';
import { StatusBar } from 'expo-status-bar';

// Telas de seleção
import WelcomeScreen from './src/screens/WelcomeScreen';

// App Cliente
import ClienteApp from './src/cliente/ClienteApp';

// App Entregador
import EntregadorApp from './src/entregador/EntregadorApp';

const Stack = createNativeStackNavigator();

export default function App() {
  return (
    <NavigationContainer>
      <StatusBar style="light" />
      <Stack.Navigator 
        initialRouteName="Welcome"
        screenOptions={{ headerShown: false }}
      >
        <Stack.Screen name="Welcome" component={WelcomeScreen} />
        <Stack.Screen name="ClienteApp" component={ClienteApp} />
        <Stack.Screen name="EntregadorApp" component={EntregadorApp} />
      </Stack.Navigator>
    </NavigationContainer>
  );
}
