# 📱 Já EntreGo - Aplicativo Mobile

Aplicativo React Native/Expo para a plataforma de entregas Já EntreGo.

## 🚀 Funcionalidades

### App Cliente
- ✅ Login e Cadastro
- ✅ Dashboard com banners promocionais
- ✅ Solicitar nova entrega
- ✅ Seleção inteligente de veículo
- ✅ Acompanhar entregas em tempo real
- ✅ Histórico de entregas
- ✅ Notificações push

### App Entregador
- ✅ Login e Cadastro com documentos
- ✅ Toggle Online/Offline
- ✅ Receber notificações de novas entregas
- ✅ Aceitar/Recusar entregas
- ✅ Navegação integrada (Waze/Google Maps)
- ✅ Confirmar coleta e entrega
- ✅ Cancelar entrega com motivos
- ✅ Visualizar ganhos (bruto/líquido)
- ✅ Histórico de entregas

## 📋 Pré-requisitos

- Node.js 18+
- npm ou yarn
- Expo CLI
- Expo Go (para testes no celular)

## 🛠️ Instalação

```bash
# Entrar na pasta do projeto mobile
cd mobile

# Instalar dependências
npm install

# Iniciar o projeto
npm start
```

## 📱 Executando

```bash
# Iniciar servidor de desenvolvimento
npx expo start

# Executar no Android
npx expo start --android

# Executar no iOS
npx expo start --ios

# Executar na web
npx expo start --web
```

## ⚙️ Configuração

### API Backend

Edite o arquivo `src/config/api.js` e altere a URL base:

```javascript
const API_BASE_URL = 'https://seu-servidor.com';
```

### Google Maps (opcional)

Para usar mapas, adicione sua API key no `app.json`:

```json
{
  "expo": {
    "android": {
      "config": {
        "googleMaps": {
          "apiKey": "SUA_API_KEY"
        }
      }
    }
  }
}
```

## 📁 Estrutura do Projeto

```
mobile/
├── App.js                    # Entrada principal
├── app.json                  # Configuração Expo
├── package.json              # Dependências
├── src/
│   ├── config/
│   │   ├── api.js           # Configuração da API
│   │   └── theme.js         # Cores e estilos
│   ├── screens/
│   │   └── WelcomeScreen.js # Tela inicial
│   ├── cliente/
│   │   ├── ClienteApp.js    # Navegação cliente
│   │   └── screens/
│   │       ├── LoginScreen.js
│   │       ├── CadastroScreen.js
│   │       ├── DashboardScreen.js
│   │       ├── NovaEntregaScreen.js
│   │       ├── EntregasScreen.js
│   │       └── PerfilScreen.js
│   └── entregador/
│       ├── EntregadorApp.js # Navegação entregador
│       └── screens/
│           ├── LoginScreen.js
│           ├── CadastroScreen.js
│           ├── DashboardScreen.js
│           ├── GanhosScreen.js
│           ├── HistoricoScreen.js
│           └── PerfilScreen.js
└── assets/
    └── sounds/
        └── notification.mp3
```

## 🎨 Temas

### Cliente
- Cor primária: `#1a73e8` (Azul)
- Cor secundária: `#00c853` (Verde)

### Entregador
- Cor primária: `#0d47a1` (Azul escuro)
- Cor secundária: `#00c853` (Verde)

## 📦 Build para Produção

```bash
# Build para Android (APK)
npx expo build:android

# Build para iOS
npx expo build:ios

# Ou usando EAS Build
npx eas build --platform android
npx eas build --platform ios
```

## 🔔 Notificações

O app usa:
- **expo-notifications** para push notifications
- **expo-haptics** para vibração
- **expo-av** para sons de notificação

## 📍 Localização

O app usa **expo-location** para:
- Obter localização atual do usuário
- Rastrear posição do entregador
- Calcular distâncias

## 🤝 Contribuição

1. Fork o projeto
2. Crie sua branch (`git checkout -b feature/nova-funcionalidade`)
3. Commit suas mudanças (`git commit -m 'Adiciona nova funcionalidade'`)
4. Push para a branch (`git push origin feature/nova-funcionalidade`)
5. Abra um Pull Request

## 📄 Licença

Este projeto está sob a licença MIT.

---

Desenvolvido com ❤️ para Já EntreGo
