import axios from 'axios';
import AsyncStorage from '@react-native-async-storage/async-storage';

// Configurar URL base da API (altere para seu servidor)
const API_BASE_URL = 'https://seu-servidor.com';

const api = axios.create({
  baseURL: API_BASE_URL,
  timeout: 10000,
  headers: {
    'Content-Type': 'application/x-www-form-urlencoded',
  },
});

// Interceptor para adicionar token de autenticação
api.interceptors.request.use(async (config) => {
  const token = await AsyncStorage.getItem('authToken');
  if (token) {
    config.headers.Authorization = `Bearer ${token}`;
  }
  return config;
});

// Funções de API para Cliente
export const clienteAPI = {
  login: (email, senha) => api.post('/api/cliente/login.php', `email=${email}&senha=${senha}`),
  cadastro: (dados) => api.post('/api/cliente/cadastro.php', dados),
  dashboard: () => api.get('/api/cliente/dashboard.php'),
  criarEntrega: (dados) => api.post('/api/cliente/criar-entrega.php', dados),
  minhasEntregas: () => api.get('/api/cliente/entregas.php'),
  verificarNotificacoes: () => api.get('/cliente/api/verificar-notificacoes.php'),
  getBanners: () => api.get('/api/cliente/banners.php'),
};

// Funções de API para Entregador
export const entregadorAPI = {
  login: (email, senha) => api.post('/api/entregador/login.php', `email=${email}&senha=${senha}`),
  cadastro: (dados) => api.post('/api/entregador/cadastro.php', dados),
  dashboard: () => api.get('/api/entregador/dashboard.php'),
  atualizarStatus: (status) => api.post('/entregador/api/atualizar-status.php', `status=${status}`),
  aceitarEntrega: (entregaId) => api.post('/entregador/api/aceitar-entrega.php', `entrega_id=${entregaId}`),
  atualizarEntrega: (entregaId, status) => api.post('/entregador/api/atualizar-entrega.php', `entrega_id=${entregaId}&status=${status}`),
  cancelarEntrega: (entregaId, motivo) => api.post('/entregador/api/cancelar-entrega.php', `entrega_id=${entregaId}&motivo=${encodeURIComponent(motivo)}`),
  verificarNotificacoes: () => api.get('/entregador/api/verificar-notificacoes.php'),
  atualizarLocalizacao: (lat, lng) => api.post('/entregador/api/atualizar-localizacao.php', `lat=${lat}&lng=${lng}`),
  ganhos: () => api.get('/api/entregador/ganhos.php'),
  historico: () => api.get('/api/entregador/historico.php'),
};

export default api;
