// Tema do aplicativo - Cores e estilos globais

export const colors = {
  // Cores principais
  primary: '#1a73e8',
  primaryDark: '#0d47a1',
  secondary: '#00c853',
  
  // Cores do entregador (tema azul escuro)
  entregador: {
    primary: '#0d47a1',
    secondary: '#1565c0',
    accent: '#00c853',
  },
  
  // Cores do cliente
  cliente: {
    primary: '#1a73e8',
    secondary: '#4285f4',
    accent: '#00c853',
  },
  
  // Status
  success: '#00c853',
  warning: '#ff9800',
  danger: '#f44336',
  info: '#2196f3',
  
  // Neutros
  white: '#ffffff',
  black: '#000000',
  gray: {
    50: '#fafafa',
    100: '#f5f5f5',
    200: '#eeeeee',
    300: '#e0e0e0',
    400: '#bdbdbd',
    500: '#9e9e9e',
    600: '#757575',
    700: '#616161',
    800: '#424242',
    900: '#212121',
  },
  
  // Backgrounds
  background: '#f5f5f5',
  card: '#ffffff',
  overlay: 'rgba(0, 0, 0, 0.5)',
};

export const fonts = {
  regular: 'System',
  medium: 'System',
  bold: 'System',
  sizes: {
    xs: 10,
    sm: 12,
    md: 14,
    lg: 16,
    xl: 18,
    xxl: 24,
    xxxl: 32,
  },
};

export const spacing = {
  xs: 4,
  sm: 8,
  md: 12,
  lg: 16,
  xl: 20,
  xxl: 24,
  xxxl: 32,
};

export const borderRadius = {
  sm: 4,
  md: 8,
  lg: 12,
  xl: 16,
  xxl: 24,
  full: 9999,
};

export const shadows = {
  sm: {
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 1 },
    shadowOpacity: 0.1,
    shadowRadius: 2,
    elevation: 2,
  },
  md: {
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 2 },
    shadowOpacity: 0.15,
    shadowRadius: 4,
    elevation: 4,
  },
  lg: {
    shadowColor: '#000',
    shadowOffset: { width: 0, height: 4 },
    shadowOpacity: 0.2,
    shadowRadius: 8,
    elevation: 8,
  },
};

export default {
  colors,
  fonts,
  spacing,
  borderRadius,
  shadows,
};
