import React from 'react';
import {
  View,
  Text,
  StyleSheet,
  TouchableOpacity,
  Image,
  SafeAreaView,
  StatusBar,
} from 'react-native';
import { LinearGradient } from 'expo-linear-gradient';
import { colors, fonts, spacing, borderRadius } from '../config/theme';

export default function WelcomeScreen({ navigation }) {
  return (
    <SafeAreaView style={styles.container}>
      <StatusBar barStyle="light-content" />
      <LinearGradient
        colors={[colors.primary, colors.primaryDark]}
        style={styles.gradient}
      >
        {/* Logo e Título */}
        <View style={styles.header}>
          <Text style={styles.logo}>🚚</Text>
          <Text style={styles.title}>Já EntreGo</Text>
          <Text style={styles.subtitle}>Entregas rápidas e seguras</Text>
        </View>

        {/* Botões de Seleção */}
        <View style={styles.buttonsContainer}>
          <Text style={styles.selectText}>Como deseja continuar?</Text>

          <TouchableOpacity
            style={[styles.button, styles.clienteButton]}
            onPress={() => navigation.navigate('ClienteApp')}
          >
            <Text style={styles.buttonIcon}>📦</Text>
            <View style={styles.buttonTextContainer}>
              <Text style={styles.buttonTitle}>Sou Cliente</Text>
              <Text style={styles.buttonSubtitle}>Quero enviar encomendas</Text>
            </View>
            <Text style={styles.arrow}>→</Text>
          </TouchableOpacity>

          <TouchableOpacity
            style={[styles.button, styles.entregadorButton]}
            onPress={() => navigation.navigate('EntregadorApp')}
          >
            <Text style={styles.buttonIcon}>🏍️</Text>
            <View style={styles.buttonTextContainer}>
              <Text style={styles.buttonTitle}>Sou Entregador</Text>
              <Text style={styles.buttonSubtitle}>Quero fazer entregas</Text>
            </View>
            <Text style={styles.arrow}>→</Text>
          </TouchableOpacity>
        </View>

        {/* Footer */}
        <View style={styles.footer}>
          <Text style={styles.footerText}>
            Ao continuar, você concorda com nossos{'\n'}
            Termos de Uso e Política de Privacidade
          </Text>
        </View>
      </LinearGradient>
    </SafeAreaView>
  );
}

const styles = StyleSheet.create({
  container: {
    flex: 1,
  },
  gradient: {
    flex: 1,
    paddingHorizontal: spacing.xl,
  },
  header: {
    flex: 1,
    justifyContent: 'center',
    alignItems: 'center',
  },
  logo: {
    fontSize: 80,
    marginBottom: spacing.md,
  },
  title: {
    fontSize: fonts.sizes.xxxl,
    fontWeight: 'bold',
    color: colors.white,
    marginBottom: spacing.xs,
  },
  subtitle: {
    fontSize: fonts.sizes.lg,
    color: 'rgba(255, 255, 255, 0.8)',
  },
  buttonsContainer: {
    flex: 1,
    justifyContent: 'center',
  },
  selectText: {
    fontSize: fonts.sizes.lg,
    color: colors.white,
    textAlign: 'center',
    marginBottom: spacing.xl,
  },
  button: {
    flexDirection: 'row',
    alignItems: 'center',
    backgroundColor: colors.white,
    borderRadius: borderRadius.xl,
    padding: spacing.lg,
    marginBottom: spacing.md,
  },
  clienteButton: {
    borderLeftWidth: 4,
    borderLeftColor: colors.primary,
  },
  entregadorButton: {
    borderLeftWidth: 4,
    borderLeftColor: colors.entregador.primary,
  },
  buttonIcon: {
    fontSize: 36,
    marginRight: spacing.md,
  },
  buttonTextContainer: {
    flex: 1,
  },
  buttonTitle: {
    fontSize: fonts.sizes.lg,
    fontWeight: 'bold',
    color: colors.gray[900],
  },
  buttonSubtitle: {
    fontSize: fonts.sizes.sm,
    color: colors.gray[600],
    marginTop: 2,
  },
  arrow: {
    fontSize: fonts.sizes.xxl,
    color: colors.gray[400],
  },
  footer: {
    paddingVertical: spacing.xxl,
    alignItems: 'center',
  },
  footerText: {
    fontSize: fonts.sizes.xs,
    color: 'rgba(255, 255, 255, 0.6)',
    textAlign: 'center',
    lineHeight: 16,
  },
});
