<?php
require_once 'config/database.php';

$sucesso = '';
$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $nome = trim($_POST['nome_empresa'] ?? '');
    $cnpj = trim($_POST['cnpj'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $telefone = trim($_POST['telefone'] ?? '');
    $endereco = trim($_POST['endereco'] ?? '');
    $responsavel = trim($_POST['responsavel'] ?? '');
    
    if (empty($nome) || empty($email)) {
        $erro = 'Nome da empresa e email são obrigatórios';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $erro = 'Email inválido';
    } else {
        try {
            $db = Database::getInstance()->getConnection();
            
            // Verificar se já existe
            if ($cnpj) {
                $stmt = $db->prepare("SELECT id FROM empresas_parceiras WHERE cnpj = ?");
                $stmt->execute([$cnpj]);
                if ($stmt->fetch()) {
                    $erro = 'Este CNPJ já está cadastrado';
                }
            }
            
            if (!$erro) {
                $stmt = $db->prepare("INSERT INTO empresas_parceiras (nome_empresa, cnpj, email, telefone, endereco, responsavel) VALUES (?, ?, ?, ?, ?, ?)");
                $stmt->execute([$nome, $cnpj, $email, $telefone, $endereco, $responsavel]);
                $sucesso = 'Cadastro enviado com sucesso! Entraremos em contato em breve.';
            }
        } catch (Exception $e) {
            $erro = 'Erro ao enviar cadastro. Tente novamente.';
        }
    }
}

// Buscar nome da empresa
$nomeEmpresa = 'Já EntreGo';
try {
    $db = Database::getInstance()->getConnection();
    $stmt = $db->prepare("SELECT valor FROM configuracoes WHERE chave = 'nome_empresa'");
    $stmt->execute();
    $result = $stmt->fetch();
    if ($result) $nomeEmpresa = $result['valor'];
} catch (Exception $e) {}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Seja Parceiro - <?= htmlspecialchars($nomeEmpresa) ?></title>
    <link rel="stylesheet" href="assets/css/style.css">
    <style>
        .hero {
            background: linear-gradient(135deg, #1a73e8 0%, #0d47a1 100%);
            color: white;
            padding: 60px 20px;
            text-align: center;
        }
        .hero h1 {
            font-size: 36px;
            margin-bottom: 16px;
        }
        .hero p {
            font-size: 18px;
            opacity: 0.9;
            max-width: 600px;
            margin: 0 auto;
        }
        .form-container {
            max-width: 600px;
            margin: -40px auto 40px;
            background: white;
            border-radius: 16px;
            padding: 40px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.1);
        }
        .beneficios {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            max-width: 900px;
            margin: 40px auto;
            padding: 0 20px;
        }
        .beneficio {
            background: white;
            padding: 24px;
            border-radius: 12px;
            text-align: center;
            box-shadow: 0 2px 10px rgba(0,0,0,0.05);
        }
        .beneficio .icon {
            font-size: 48px;
            margin-bottom: 16px;
        }
        .beneficio h3 {
            color: #333;
            margin-bottom: 8px;
        }
        .beneficio p {
            color: #666;
            font-size: 14px;
        }
    </style>
</head>
<body style="background: #f5f5f5;">
    <div class="hero">
        <h1>🤝 Seja um Parceiro <?= htmlspecialchars($nomeEmpresa) ?></h1>
        <p>Aumente suas vendas oferecendo entregas rápidas e seguras para seus clientes</p>
    </div>
    
    <div class="form-container">
        <?php if ($sucesso): ?>
            <div style="text-align: center; padding: 40px 0;">
                <div style="font-size: 80px; margin-bottom: 20px;">✅</div>
                <h2 style="color: #4caf50; margin-bottom: 16px;">Cadastro Enviado!</h2>
                <p style="color: #666;"><?= htmlspecialchars($sucesso) ?></p>
                <a href="index.php" class="btn btn-primary" style="margin-top: 20px;">Voltar ao Início</a>
            </div>
        <?php else: ?>
            <h2 style="text-align: center; margin-bottom: 24px;">Cadastre sua Empresa</h2>
            
            <?php if ($erro): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($erro) ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>Nome da Empresa *</label>
                    <input type="text" name="nome_empresa" class="form-control" required 
                           value="<?= htmlspecialchars($_POST['nome_empresa'] ?? '') ?>">
                </div>
                
                <div class="form-group">
                    <label>CNPJ</label>
                    <input type="text" name="cnpj" class="form-control" placeholder="00.000.000/0000-00"
                           value="<?= htmlspecialchars($_POST['cnpj'] ?? '') ?>">
                </div>
                
                <div class="form-group">
                    <label>Nome do Responsável</label>
                    <input type="text" name="responsavel" class="form-control"
                           value="<?= htmlspecialchars($_POST['responsavel'] ?? '') ?>">
                </div>
                
                <div class="form-group">
                    <label>Email *</label>
                    <input type="email" name="email" class="form-control" required
                           value="<?= htmlspecialchars($_POST['email'] ?? '') ?>">
                </div>
                
                <div class="form-group">
                    <label>Telefone</label>
                    <input type="tel" name="telefone" class="form-control"
                           value="<?= htmlspecialchars($_POST['telefone'] ?? '') ?>">
                </div>
                
                <div class="form-group">
                    <label>Endereço</label>
                    <input type="text" name="endereco" class="form-control"
                           value="<?= htmlspecialchars($_POST['endereco'] ?? '') ?>">
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">Enviar Cadastro</button>
            </form>
        <?php endif; ?>
    </div>
    
    <div class="beneficios">
        <div class="beneficio">
            <div class="icon">🚀</div>
            <h3>Entregas Rápidas</h3>
            <p>Entregadores disponíveis para coletar e entregar em minutos</p>
        </div>
        <div class="beneficio">
            <div class="icon">📱</div>
            <h3>Rastreamento</h3>
            <p>Acompanhe todas as entregas em tempo real</p>
        </div>
        <div class="beneficio">
            <div class="icon">💰</div>
            <h3>Preços Competitivos</h3>
            <p>Condições especiais para empresas parceiras</p>
        </div>
    </div>
    
    <div style="text-align: center; padding: 20px; color: #666;">
        <a href="index.php" style="color: #1a73e8;">← Voltar ao início</a>
    </div>
</body>
</html>
