# Já EntreGo - Plataforma de Entregas

Sistema de entregas similar ao Lalamove, desenvolvido em PHP puro com MySQL.

## Requisitos

- PHP 7.4 ou superior
- MySQL 5.7 ou superior
- Servidor web (Apache/Nginx)

## Instalação

### 1. Configurar o Banco de Dados

Execute o script SQL para criar o banco de dados:

```bash
mysql -u root -p < database/schema.sql
```

Ou importe o arquivo `database/schema.sql` pelo phpMyAdmin.

### 2. Configurar Conexão

Edite o arquivo `config/database.php` com suas credenciais:

```php
define('DB_HOST', 'localhost');
define('DB_NAME', 'entregas_db');
define('DB_USER', 'root');
define('DB_PASS', 'sua_senha');
```

### 3. Configurar Servidor Web

Aponte o DocumentRoot para a pasta do projeto.

Para Apache, crie um `.htaccess` se necessário:
```apache
RewriteEngine On
RewriteCond %{REQUEST_FILENAME} !-f
RewriteCond %{REQUEST_FILENAME} !-d
```

## Estrutura do Projeto

```
/
├── config/             # Configurações
│   ├── database.php    # Conexão com banco
│   └── auth.php        # Autenticação
├── assets/
│   ├── css/
│   │   ├── style.css       # Estilos gerais
│   │   └── entregador.css  # Estilos app entregador (azul)
│   └── js/
│       └── notificacao.js  # Sistema de notificações
├── cliente/            # Área do cliente
│   ├── dashboard.php
│   ├── nova-entrega.php
│   └── logout.php
├── entregador/         # App do entregador
│   ├── index.php       # Login
│   ├── cadastro.php
│   ├── dashboard.php   # Tela principal
│   ├── historico.php
│   ├── ganhos.php
│   ├── logout.php
│   └── api/            # APIs para o app
│       ├── atualizar-status.php
│       ├── aceitar-entrega.php
│       ├── atualizar-entrega.php
│       └── verificar-notificacoes.php
├── admin/              # Painel administrativo
│   ├── index.php
│   ├── dashboard.php
│   ├── entregas.php
│   ├── entregadores.php
│   ├── usuarios.php
│   └── logout.php
├── database/
│   └── schema.sql      # Script do banco
├── index.php           # Login cliente
├── cadastro.php        # Cadastro cliente
└── README.md
```

## Acessos

### Cliente
- URL: `/index.php`
- Cadastre-se ou faça login para solicitar entregas

### Entregador
- URL: `/entregador/`
- Cadastre-se como entregador
- Receba notificações sonoras quando houver novas entregas
- Tema em azul

### Admin
- URL: `/admin/`
- Login padrão: `admin@entregas.com` / `admin123`

## Funcionalidades

### Cliente
- Cadastro e login
- Solicitar nova entrega
- Acompanhar status das entregas
- Ver histórico

### Entregador
- Cadastro com dados do veículo
- Toggle online/offline
- Receber notificações de novas entregas (som + visual + navegador)
- Aceitar entregas
- Confirmar coleta e entrega
- Ver histórico e ganhos

### Admin
- Dashboard com estatísticas
- Gerenciar entregas
- Ver entregadores e status
- Ver clientes cadastrados

## Sistema de Notificações

O app do entregador possui sistema de notificações que:
- Verifica novas entregas a cada 5 segundos
- Toca som de alerta
- Vibra o dispositivo (se suportado)
- Mostra notificação visual na tela
- Envia notificação do navegador (se permitido)

## Tecnologias

- PHP 7.4+ (sem frameworks)
- MySQL (PDO)
- HTML5/CSS3
- JavaScript Vanilla
- Web Audio API (para sons)
- Notification API (para notificações do navegador)
