<?php
/**
 * API para verificar novos cadastros (entregadores, clientes, parceiros)
 */
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

// Verificar se está logado como admin
if (!isLoggedIn('admin')) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

try {
    $db = Database::getInstance()->getConnection();
    
    // Pegar timestamp da última verificação
    $ultima = $_GET['ultima'] ?? date('Y-m-d H:i:s', strtotime('-1 day'));
    
    // Buscar entregadores pendentes de aprovação
    $stmt = $db->prepare("
        SELECT id, nome, email, created_at 
        FROM entregadores 
        WHERE aprovado = 'pendente'
        ORDER BY created_at DESC
        LIMIT 20
    ");
    $stmt->execute();
    $entregadores = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Buscar novos usuários (últimas 24h)
    $stmt = $db->prepare("
        SELECT id, nome, email, created_at 
        FROM usuarios 
        WHERE created_at >= DATE_SUB(NOW(), INTERVAL 24 HOUR)
        ORDER BY created_at DESC
        LIMIT 20
    ");
    $stmt->execute();
    $usuarios = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Buscar parceiros pendentes
    $stmt = $db->prepare("
        SELECT id, nome_empresa, email, created_at 
        FROM empresas_parceiras 
        WHERE status = 'pendente'
        ORDER BY created_at DESC
        LIMIT 20
    ");
    $stmt->execute();
    $parceiros = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    // Verificar se há novos desde última verificação
    $temNovas = false;
    
    foreach ($entregadores as $e) {
        if ($e['created_at'] > $ultima) {
            $temNovas = true;
            break;
        }
    }
    
    if (!$temNovas) {
        foreach ($usuarios as $u) {
            if ($u['created_at'] > $ultima) {
                $temNovas = true;
                break;
            }
        }
    }
    
    if (!$temNovas) {
        foreach ($parceiros as $p) {
            if ($p['created_at'] > $ultima) {
                $temNovas = true;
                break;
            }
        }
    }
    
    echo json_encode([
        'success' => true,
        'entregadores' => $entregadores,
        'usuarios' => $usuarios,
        'parceiros' => $parceiros,
        'temNovas' => $temNovas,
        'timestamp' => date('Y-m-d H:i:s')
    ]);
    
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Erro: ' . $e->getMessage()]);
}
