<?php
require_once '../config/database.php';
require_once '../config/auth.php';
requireLogin('admin', 'index.php');

$db = Database::getInstance()->getConnection();
$sucesso = '';
$erro = '';

// Processar ações
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $acao = $_POST['acao'] ?? '';
    
    // Adicionar/Editar banner
    if ($acao === 'salvar') {
        $id = intval($_POST['id'] ?? 0);
        $titulo = trim($_POST['titulo'] ?? '');
        $descricao = trim($_POST['descricao'] ?? '');
        $corFundo = $_POST['cor_fundo'] ?? '#1a73e8';
        $corTexto = $_POST['cor_texto'] ?? '#ffffff';
        $link = trim($_POST['link'] ?? '');
        $ordem = intval($_POST['ordem'] ?? 0);
        $ativo = isset($_POST['ativo']) ? 1 : 0;
        
        // Upload de imagem
        $imagem = $_POST['imagem_atual'] ?? '';
        if (isset($_FILES['imagem']) && $_FILES['imagem']['error'] === UPLOAD_ERR_OK) {
            $ext = strtolower(pathinfo($_FILES['imagem']['name'], PATHINFO_EXTENSION));
            if (in_array($ext, ['jpg', 'jpeg', 'png', 'gif', 'webp'])) {
                $nomeArquivo = 'banner_' . time() . '_' . uniqid() . '.' . $ext;
                $destino = '../uploads/banners/' . $nomeArquivo;
                
                if (!is_dir('../uploads/banners')) {
                    mkdir('../uploads/banners', 0755, true);
                }
                
                if (move_uploaded_file($_FILES['imagem']['tmp_name'], $destino)) {
                    $imagem = 'uploads/banners/' . $nomeArquivo;
                }
            }
        }
        
        if (empty($titulo)) {
            $erro = 'Informe o título do banner';
        } else {
            if ($id > 0) {
                $stmt = $db->prepare("UPDATE banners SET titulo = ?, descricao = ?, imagem = ?, cor_fundo = ?, cor_texto = ?, link = ?, ordem = ?, ativo = ? WHERE id = ?");
                $stmt->execute([$titulo, $descricao, $imagem, $corFundo, $corTexto, $link, $ordem, $ativo, $id]);
                $sucesso = 'Banner atualizado com sucesso!';
            } else {
                // Verificar limite de 4 banners
                $stmt = $db->query("SELECT COUNT(*) FROM banners");
                if ($stmt->fetchColumn() >= 4) {
                    $erro = 'Limite máximo de 4 banners atingido. Exclua um banner para adicionar outro.';
                } else {
                    $stmt = $db->prepare("INSERT INTO banners (titulo, descricao, imagem, cor_fundo, cor_texto, link, ordem, ativo) VALUES (?, ?, ?, ?, ?, ?, ?, ?)");
                    $stmt->execute([$titulo, $descricao, $imagem, $corFundo, $corTexto, $link, $ordem, $ativo]);
                    $sucesso = 'Banner adicionado com sucesso!';
                }
            }
        }
    }
    
    // Excluir banner
    if ($acao === 'excluir') {
        $id = intval($_POST['id'] ?? 0);
        $stmt = $db->prepare("DELETE FROM banners WHERE id = ?");
        $stmt->execute([$id]);
        $sucesso = 'Banner excluído com sucesso!';
    }
    
    // Toggle ativo
    if ($acao === 'toggle') {
        $id = intval($_POST['id'] ?? 0);
        $stmt = $db->prepare("UPDATE banners SET ativo = NOT ativo WHERE id = ?");
        $stmt->execute([$id]);
        $sucesso = 'Status do banner alterado!';
    }
}

// Buscar banners
$stmt = $db->query("SELECT * FROM banners ORDER BY ordem ASC, id DESC");
$banners = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Banner para edição
$bannerEdit = null;
if (isset($_GET['editar'])) {
    $stmt = $db->prepare("SELECT * FROM banners WHERE id = ?");
    $stmt->execute([intval($_GET['editar'])]);
    $bannerEdit = $stmt->fetch(PDO::FETCH_ASSOC);
}

$pageTitle = 'Banners';
include 'includes/header.php';
?>
    
    <div class="container">
        <h2 style="margin-bottom: 20px;">🎨 Banners Promocionais</h2>
        
        <?php if ($sucesso): ?>
            <div class="alert alert-success"><?= htmlspecialchars($sucesso) ?></div>
        <?php endif; ?>
        
        <?php if ($erro): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>
        
        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 20px;">
            <!-- Formulário -->
            <div class="card">
                <h3 style="margin-bottom: 20px;"><?= $bannerEdit ? '✏️ Editar Banner' : '➕ Novo Banner' ?></h3>
                
                <?php if (count($banners) >= 4 && !$bannerEdit): ?>
                    <div class="alert" style="background: #fff3e0; color: #e65100;">
                        ⚠️ Limite de 4 banners atingido. Exclua um banner para adicionar outro.
                    </div>
                <?php else: ?>
                    <form method="POST" enctype="multipart/form-data">
                        <input type="hidden" name="acao" value="salvar">
                        <input type="hidden" name="id" value="<?= $bannerEdit['id'] ?? 0 ?>">
                        <input type="hidden" name="imagem_atual" value="<?= $bannerEdit['imagem'] ?? '' ?>">
                        
                        <div class="form-group">
                            <label>Título *</label>
                            <input type="text" name="titulo" class="form-control" required 
                                   value="<?= htmlspecialchars($bannerEdit['titulo'] ?? '') ?>"
                                   placeholder="Ex: Frete Grátis!">
                        </div>
                        
                        <div class="form-group">
                            <label>Descrição</label>
                            <input type="text" name="descricao" class="form-control" 
                                   value="<?= htmlspecialchars($bannerEdit['descricao'] ?? '') ?>"
                                   placeholder="Ex: Em pedidos acima de R$ 50">
                        </div>
                        
                        <div class="form-group">
                            <label>Imagem (opcional)</label>
                            <input type="file" name="imagem" class="form-control" accept="image/*">
                            <?php if (!empty($bannerEdit['imagem'])): ?>
                                <small style="color: var(--text-muted);">Imagem atual: <?= basename($bannerEdit['imagem']) ?></small>
                            <?php endif; ?>
                        </div>
                        
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                            <div class="form-group">
                                <label>Cor de Fundo</label>
                                <input type="color" name="cor_fundo" class="form-control" style="height: 45px; padding: 5px;"
                                       value="<?= $bannerEdit['cor_fundo'] ?? '#1a73e8' ?>">
                            </div>
                            <div class="form-group">
                                <label>Cor do Texto</label>
                                <input type="color" name="cor_texto" class="form-control" style="height: 45px; padding: 5px;"
                                       value="<?= $bannerEdit['cor_texto'] ?? '#ffffff' ?>">
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <label>Link (opcional)</label>
                            <input type="url" name="link" class="form-control" 
                                   value="<?= htmlspecialchars($bannerEdit['link'] ?? '') ?>"
                                   placeholder="https://...">
                        </div>
                        
                        <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 15px;">
                            <div class="form-group">
                                <label>Ordem</label>
                                <input type="number" name="ordem" class="form-control" min="0" max="10"
                                       value="<?= $bannerEdit['ordem'] ?? 0 ?>">
                            </div>
                            <div class="form-group">
                                <label style="display: block; margin-bottom: 10px;">Status</label>
                                <label style="display: flex; align-items: center; gap: 8px; cursor: pointer;">
                                    <input type="checkbox" name="ativo" <?= ($bannerEdit['ativo'] ?? 1) ? 'checked' : '' ?>>
                                    Ativo
                                </label>
                            </div>
                        </div>
                        
                        <div style="display: flex; gap: 10px;">
                            <button type="submit" class="btn btn-primary">
                                <?= $bannerEdit ? '💾 Salvar Alterações' : '➕ Adicionar Banner' ?>
                            </button>
                            <?php if ($bannerEdit): ?>
                                <a href="banners.php" class="btn" style="background: var(--border-color);">Cancelar</a>
                            <?php endif; ?>
                        </div>
                    </form>
                <?php endif; ?>
            </div>
            
            <!-- Preview e Lista -->
            <div>
                <!-- Preview -->
                <div class="card" style="margin-bottom: 20px;">
                    <h3 style="margin-bottom: 15px;">👁️ Preview</h3>
                    <div style="display: flex; gap: 10px; overflow-x: auto; padding: 10px 0;">
                        <?php if (empty($banners)): ?>
                            <div style="text-align: center; padding: 30px; color: var(--text-muted); width: 100%;">
                                Nenhum banner cadastrado
                            </div>
                        <?php else: ?>
                            <?php foreach ($banners as $b): ?>
                                <?php if ($b['ativo']): ?>
                                <div style="min-width: 200px; padding: 15px; border-radius: 12px; background: <?= htmlspecialchars($b['cor_fundo']) ?>; color: <?= htmlspecialchars($b['cor_texto']) ?>; text-align: center;">
                                    <?php if (!empty($b['imagem'])): ?>
                                        <img src="../<?= htmlspecialchars($b['imagem']) ?>" style="max-width: 100%; max-height: 60px; margin-bottom: 8px; border-radius: 8px;">
                                    <?php endif; ?>
                                    <div style="font-weight: 600; font-size: 14px;"><?= htmlspecialchars($b['titulo']) ?></div>
                                    <?php if ($b['descricao']): ?>
                                        <div style="font-size: 11px; opacity: 0.9; margin-top: 4px;"><?= htmlspecialchars($b['descricao']) ?></div>
                                    <?php endif; ?>
                                </div>
                                <?php endif; ?>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </div>
                </div>
                
                <!-- Lista de Banners -->
                <div class="card">
                    <h3 style="margin-bottom: 15px;">📋 Banners Cadastrados (<?= count($banners) ?>/4)</h3>
                    
                    <?php if (empty($banners)): ?>
                        <p style="color: var(--text-muted); text-align: center; padding: 20px;">
                            Nenhum banner cadastrado ainda.
                        </p>
                    <?php else: ?>
                        <?php foreach ($banners as $b): ?>
                        <div style="display: flex; align-items: center; gap: 15px; padding: 12px; border-bottom: 1px solid var(--border-color); <?= !$b['ativo'] ? 'opacity: 0.5;' : '' ?>">
                            <div style="width: 50px; height: 50px; border-radius: 8px; background: <?= htmlspecialchars($b['cor_fundo']) ?>; display: flex; align-items: center; justify-content: center; color: <?= htmlspecialchars($b['cor_texto']) ?>; font-size: 20px;">
                                <?= $b['ordem'] ?>
                            </div>
                            <div style="flex: 1;">
                                <strong><?= htmlspecialchars($b['titulo']) ?></strong>
                                <?php if ($b['descricao']): ?>
                                    <div style="font-size: 12px; color: var(--text-muted);"><?= htmlspecialchars($b['descricao']) ?></div>
                                <?php endif; ?>
                            </div>
                            <div style="display: flex; gap: 8px;">
                                <form method="POST" style="display: inline;">
                                    <input type="hidden" name="acao" value="toggle">
                                    <input type="hidden" name="id" value="<?= $b['id'] ?>">
                                    <button type="submit" class="btn btn-sm" style="background: <?= $b['ativo'] ? '#e8f5e9' : '#ffebee' ?>; color: <?= $b['ativo'] ? '#2e7d32' : '#c62828' ?>;">
                                        <?= $b['ativo'] ? '✅' : '❌' ?>
                                    </button>
                                </form>
                                <a href="?editar=<?= $b['id'] ?>" class="btn btn-sm" style="background: #e3f2fd; color: #1a73e8;">✏️</a>
                                <form method="POST" style="display: inline;" onsubmit="return confirm('Excluir este banner?')">
                                    <input type="hidden" name="acao" value="excluir">
                                    <input type="hidden" name="id" value="<?= $b['id'] ?>">
                                    <button type="submit" class="btn btn-sm" style="background: #ffebee; color: #c62828;">🗑️</button>
                                </form>
                            </div>
                        </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </div>
    
    <style>
        .btn-sm {
            padding: 6px 10px;
            font-size: 14px;
            border: none;
            border-radius: 6px;
            cursor: pointer;
        }
    </style>
</body>
</html>
