<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Admin' ?> - Já EntreGo</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <script src="../assets/js/admin-theme.js"></script>
    <?php if (isset($extraStyles)): ?>
    <style><?= $extraStyles ?></style>
    <?php endif; ?>
    <style>
        .notif-bell {
            position: relative;
            cursor: pointer;
            font-size: 20px;
            padding: 8px 12px;
            border-radius: 8px;
            transition: all 0.3s;
        }
        .notif-bell:hover {
            background: rgba(255,255,255,0.15);
        }
        .notif-bell.has-notif {
            animation: bellShake 0.5s ease-in-out;
        }
        .notif-badge {
            position: absolute;
            top: 2px;
            right: 2px;
            background: #ff1744;
            color: white;
            font-size: 11px;
            font-weight: bold;
            min-width: 18px;
            height: 18px;
            border-radius: 9px;
            display: flex;
            align-items: center;
            justify-content: center;
            display: none;
        }
        .notif-badge.show {
            display: flex;
        }
        @keyframes bellShake {
            0%, 100% { transform: rotate(0); }
            20%, 60% { transform: rotate(15deg); }
            40%, 80% { transform: rotate(-15deg); }
        }
        .notif-dropdown {
            position: absolute;
            top: 100%;
            right: 0;
            background: var(--card-bg, white);
            border-radius: 12px;
            box-shadow: 0 4px 20px rgba(0,0,0,0.2);
            min-width: 320px;
            max-height: 400px;
            overflow-y: auto;
            display: none;
            z-index: 1000;
        }
        .notif-dropdown.show {
            display: block;
        }
        .notif-dropdown-header {
            padding: 15px;
            border-bottom: 1px solid var(--border-color, #e0e0e0);
            font-weight: 600;
            color: var(--text-color, #333);
        }
        .notif-item {
            padding: 12px 15px;
            border-bottom: 1px solid var(--border-color, #e0e0e0);
            cursor: pointer;
            transition: background 0.2s;
            color: var(--text-color, #333);
        }
        .notif-item:hover {
            background: var(--hover-bg, #f5f5f5);
        }
        .notif-item:last-child {
            border-bottom: none;
        }
        .notif-item .icon {
            font-size: 24px;
            margin-right: 10px;
        }
        .notif-item .info {
            flex: 1;
        }
        .notif-item .titulo {
            font-weight: 500;
            font-size: 14px;
        }
        .notif-item .subtitulo {
            font-size: 12px;
            color: var(--text-muted, #666);
            margin-top: 2px;
        }
        .notif-item .tempo {
            font-size: 11px;
            color: var(--text-muted, #999);
        }
        .notif-empty {
            padding: 30px;
            text-align: center;
            color: var(--text-muted, #666);
        }
        .header nav {
            display: flex;
            align-items: center;
            gap: 5px;
        }
    </style>
</head>
<body class="admin-panel">
    <header class="header">
        <h1>⚙️ Já EntreGo Admin</h1>
        <nav>
            <a href="dashboard.php" <?= basename($_SERVER['PHP_SELF']) == 'dashboard.php' ? 'style="background:rgba(255,255,255,0.15)"' : '' ?>>Dashboard</a>
            <a href="entregas.php" <?= basename($_SERVER['PHP_SELF']) == 'entregas.php' ? 'style="background:rgba(255,255,255,0.15)"' : '' ?>>Entregas</a>
            <a href="entregadores.php" <?= basename($_SERVER['PHP_SELF']) == 'entregadores.php' ? 'style="background:rgba(255,255,255,0.15)"' : '' ?>>Entregadores</a>
            <a href="usuarios.php" <?= basename($_SERVER['PHP_SELF']) == 'usuarios.php' ? 'style="background:rgba(255,255,255,0.15)"' : '' ?>>Usuários</a>
            <a href="parceiros.php" <?= basename($_SERVER['PHP_SELF']) == 'parceiros.php' ? 'style="background:rgba(255,255,255,0.15)"' : '' ?>>Parceiros</a>
            <a href="banners.php" <?= basename($_SERVER['PHP_SELF']) == 'banners.php' ? 'style="background:rgba(255,255,255,0.15)"' : '' ?>>Banners</a>
            <a href="configuracoes.php" <?= basename($_SERVER['PHP_SELF']) == 'configuracoes.php' ? 'style="background:rgba(255,255,255,0.15)"' : '' ?>>Configurações</a>
            <a href="perfil.php" <?= basename($_SERVER['PHP_SELF']) == 'perfil.php' ? 'style="background:rgba(255,255,255,0.15)"' : '' ?>>Perfil</a>
            
            <!-- Sininho de Notificação -->
            <div class="notif-bell" id="notif-bell" onclick="toggleNotifDropdown()">
                🔔
                <span class="notif-badge" id="notif-badge">0</span>
                <div class="notif-dropdown" id="notif-dropdown">
                    <div class="notif-dropdown-header">Notificações</div>
                    <div id="notif-list">
                        <div class="notif-empty">Nenhuma notificação</div>
                    </div>
                </div>
            </div>
            
            <a href="logout.php">Sair</a>
            <div class="theme-toggle">
                <button type="button" id="theme-toggle-btn" class="theme-toggle-btn" onclick="toggleTheme()" title="Alternar tema">🌙</button>
            </div>
        </nav>
    </header>
    
    <script>
    let ultimaVerificacao = localStorage.getItem('admin_ultima_verif') || new Date().toISOString();
    let notificacoesVistas = JSON.parse(localStorage.getItem('admin_notifs_vistas') || '[]');
    let audioContext = null;
    
    // Toggle dropdown
    function toggleNotifDropdown() {
        const dropdown = document.getElementById('notif-dropdown');
        dropdown.classList.toggle('show');
        
        // Fechar ao clicar fora
        if (dropdown.classList.contains('show')) {
            setTimeout(() => {
                document.addEventListener('click', fecharDropdown);
            }, 100);
        }
    }
    
    function fecharDropdown(e) {
        const bell = document.getElementById('notif-bell');
        if (!bell.contains(e.target)) {
            document.getElementById('notif-dropdown').classList.remove('show');
            document.removeEventListener('click', fecharDropdown);
        }
    }
    
    // Tocar som de notificação
    function tocarSomNotificacao() {
        try {
            if (!audioContext) {
                audioContext = new (window.AudioContext || window.webkitAudioContext)();
            }
            
            // Som de sino
            const osc = audioContext.createOscillator();
            const gain = audioContext.createGain();
            osc.connect(gain);
            gain.connect(audioContext.destination);
            
            osc.frequency.setValueAtTime(830, audioContext.currentTime);
            osc.frequency.exponentialRampToValueAtTime(415, audioContext.currentTime + 0.1);
            osc.type = 'sine';
            
            gain.gain.setValueAtTime(0.5, audioContext.currentTime);
            gain.gain.exponentialRampToValueAtTime(0.01, audioContext.currentTime + 0.5);
            
            osc.start(audioContext.currentTime);
            osc.stop(audioContext.currentTime + 0.5);
            
            // Segunda nota
            setTimeout(() => {
                const osc2 = audioContext.createOscillator();
                const gain2 = audioContext.createGain();
                osc2.connect(gain2);
                gain2.connect(audioContext.destination);
                osc2.frequency.setValueAtTime(1046, audioContext.currentTime);
                osc2.type = 'sine';
                gain2.gain.setValueAtTime(0.4, audioContext.currentTime);
                gain2.gain.exponentialRampToValueAtTime(0.01, audioContext.currentTime + 0.3);
                osc2.start(audioContext.currentTime);
                osc2.stop(audioContext.currentTime + 0.3);
            }, 150);
        } catch(e) {
            console.log('Erro ao tocar som:', e);
        }
    }
    
    // Animar sininho
    function animarSininho() {
        const bell = document.getElementById('notif-bell');
        bell.classList.add('has-notif');
        setTimeout(() => bell.classList.remove('has-notif'), 500);
    }
    
    // Verificar novos cadastros
    function verificarNovosCadastros() {
        fetch('api/verificar-cadastros.php?ultima=' + encodeURIComponent(ultimaVerificacao))
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    let novasNotifs = [];
                    
                    // Processar novos entregadores
                    data.entregadores.forEach(e => {
                        const id = 'ent_' + e.id;
                        if (!notificacoesVistas.includes(id)) {
                            novasNotifs.push({
                                id: id,
                                tipo: 'entregador',
                                titulo: 'Novo Entregador',
                                subtitulo: e.nome,
                                tempo: e.created_at,
                                link: 'entregadores.php'
                            });
                        }
                    });
                    
                    // Processar novos clientes
                    data.usuarios.forEach(u => {
                        const id = 'usr_' + u.id;
                        if (!notificacoesVistas.includes(id)) {
                            novasNotifs.push({
                                id: id,
                                tipo: 'usuario',
                                titulo: 'Novo Cliente',
                                subtitulo: u.nome,
                                tempo: u.created_at,
                                link: 'usuarios.php'
                            });
                        }
                    });
                    
                    // Processar novos parceiros
                    data.parceiros.forEach(p => {
                        const id = 'par_' + p.id;
                        if (!notificacoesVistas.includes(id)) {
                            novasNotifs.push({
                                id: id,
                                tipo: 'parceiro',
                                titulo: 'Novo Parceiro',
                                subtitulo: p.nome_empresa,
                                tempo: p.created_at,
                                link: 'parceiros.php'
                            });
                        }
                    });
                    
                    // Atualizar badge
                    const badge = document.getElementById('notif-badge');
                    const total = novasNotifs.length;
                    badge.textContent = total > 9 ? '9+' : total;
                    badge.classList.toggle('show', total > 0);
                    
                    // Atualizar lista
                    atualizarListaNotificacoes(novasNotifs);
                    
                    // Se houver novas notificações desde última verificação
                    if (data.temNovas && novasNotifs.length > 0) {
                        tocarSomNotificacao();
                        animarSininho();
                    }
                    
                    // Atualizar timestamp
                    ultimaVerificacao = data.timestamp;
                    localStorage.setItem('admin_ultima_verif', ultimaVerificacao);
                }
            })
            .catch(e => console.log('Erro:', e));
    }
    
    // Atualizar lista de notificações
    function atualizarListaNotificacoes(notifs) {
        const lista = document.getElementById('notif-list');
        
        if (notifs.length === 0) {
            lista.innerHTML = '<div class="notif-empty">Nenhuma notificação pendente</div>';
            return;
        }
        
        let html = '';
        notifs.forEach(n => {
            const icone = n.tipo === 'entregador' ? '🏍️' : (n.tipo === 'parceiro' ? '🏢' : '👤');
            html += `
                <div class="notif-item" style="display:flex;align-items:center;" onclick="abrirNotificacao('${n.id}', '${n.link}')">
                    <span class="icon">${icone}</span>
                    <div class="info">
                        <div class="titulo">${n.titulo}</div>
                        <div class="subtitulo">${n.subtitulo}</div>
                    </div>
                </div>
            `;
        });
        lista.innerHTML = html;
    }
    
    // Abrir notificação
    function abrirNotificacao(id, link) {
        notificacoesVistas.push(id);
        localStorage.setItem('admin_notifs_vistas', JSON.stringify(notificacoesVistas));
        window.location.href = link;
    }
    
    // Verificar a cada 10 segundos
    verificarNovosCadastros();
    setInterval(verificarNovosCadastros, 10000);
    </script>
