<?php
require_once '../config/database.php';
require_once '../config/auth.php';

if (isLoggedIn('admin')) {
    header('Location: dashboard.php');
    exit;
}

$erro = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $senha = $_POST['senha'] ?? '';
    
    $db = Database::getInstance()->getConnection();
    $stmt = $db->prepare("SELECT id, nome, email, senha FROM admins WHERE email = ?");
    $stmt->execute([$email]);
    $admin = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($admin && password_verify($senha, $admin['senha'])) {
        login('admin', $admin['id'], $admin['nome'], $admin['email']);
        header('Location: dashboard.php');
        exit;
    } else {
        $erro = 'Email ou senha inválidos';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - Já EntreGo</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <div class="login-container" style="background: linear-gradient(135deg, #1a237e 0%, #0d47a1 100%);">
        <div class="login-box">
            <div class="logo">⚙️</div>
            <h2 style="color: #1a237e;">Painel Administrativo</h2>
            
            <?php if ($erro): ?>
                <div class="alert alert-danger"><?= htmlspecialchars($erro) ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Senha</label>
                    <input type="password" name="senha" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-block" style="background: #1a237e; color: white;">Entrar</button>
            </form>
            
            <p style="text-align: center; margin-top: 20px;">
                <a href="../index.php" style="color: #1a237e;">← Voltar</a>
            </p>
        </div>
    </div>
</body>
</html>
