<?php
require_once '../config/database.php';
require_once '../config/auth.php';
requireLogin('admin', 'index.php');

$db = Database::getInstance()->getConnection();
$sucesso = '';
$erro = '';

// Salvar perfil da empresa
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['salvar_empresa'])) {
    try {
        $campos = ['nome_empresa', 'email_empresa', 'telefone_empresa', 'endereco_empresa'];
        foreach ($campos as $campo) {
            $valor = trim($_POST[$campo] ?? '');
            $stmt = $db->prepare("INSERT INTO configuracoes (chave, valor, descricao) VALUES (?, ?, ?) 
                                  ON DUPLICATE KEY UPDATE valor = ?");
            $stmt->execute([$campo, $valor, '', $valor]);
        }
        $sucesso = 'Dados da empresa atualizados com sucesso!';
    } catch (Exception $e) {
        $erro = 'Erro ao salvar: ' . $e->getMessage();
    }
}

// Alterar senha do admin
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['alterar_senha'])) {
    $senhaAtual = $_POST['senha_atual'] ?? '';
    $novaSenha = $_POST['nova_senha'] ?? '';
    $confirmar = $_POST['confirmar_senha'] ?? '';
    
    $stmt = $db->prepare("SELECT senha FROM admins WHERE id = ?");
    $stmt->execute([getCurrentUserId('admin')]);
    $admin = $stmt->fetch();
    
    if (!password_verify($senhaAtual, $admin['senha'])) {
        $erro = 'Senha atual incorreta';
    } elseif (strlen($novaSenha) < 6) {
        $erro = 'A nova senha deve ter pelo menos 6 caracteres';
    } elseif ($novaSenha !== $confirmar) {
        $erro = 'As senhas não conferem';
    } else {
        $hash = password_hash($novaSenha, PASSWORD_DEFAULT);
        $stmt = $db->prepare("UPDATE admins SET senha = ? WHERE id = ?");
        $stmt->execute([$hash, getCurrentUserId('admin')]);
        $sucesso = 'Senha alterada com sucesso!';
    }
}

// Atualizar dados do admin
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['salvar_admin'])) {
    $nome = trim($_POST['admin_nome'] ?? '');
    $email = trim($_POST['admin_email'] ?? '');
    
    if (empty($nome) || empty($email)) {
        $erro = 'Nome e email são obrigatórios';
    } else {
        $stmt = $db->prepare("UPDATE admins SET nome = ?, email = ? WHERE id = ?");
        $stmt->execute([$nome, $email, getCurrentUserId('admin')]);
        login('admin', getCurrentUserId('admin'), $nome, $email);
        $sucesso = 'Dados atualizados com sucesso!';
    }
}

// Buscar dados atuais
$stmt = $db->prepare("SELECT * FROM admins WHERE id = ?");
$stmt->execute([getCurrentUserId('admin')]);
$adminData = $stmt->fetch(PDO::FETCH_ASSOC);

// Buscar configurações da empresa
$configs = [];
$stmt = $db->query("SELECT chave, valor FROM configuracoes WHERE chave LIKE '%_empresa'");
while ($row = $stmt->fetch(PDO::FETCH_ASSOC)) {
    $configs[$row['chave']] = $row['valor'];
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Perfil - Já EntreGo Admin</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/admin.css">
    <script src="../assets/js/admin-theme.js"></script>
    <style>
        .perfil-section {
            background: var(--bg-secondary);
            border-radius: 12px;
            padding: 24px;
            margin-bottom: 20px;
            box-shadow: var(--card-shadow);
            border: 1px solid var(--border-color);
        }
        .perfil-section h3 {
            color: var(--accent);
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 2px solid var(--border-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }
        .form-row {
            display: flex;
            gap: 20px;
            margin-bottom: 16px;
        }
        .form-row .form-group {
            flex: 1;
        }
        .logo-preview {
            width: 100px;
            height: 100px;
            border-radius: 12px;
            background: var(--bg-primary);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 48px;
            margin-bottom: 16px;
            border: 1px solid var(--border-color);
        }
        .tab {
            padding: 12px 24px;
            background: var(--bg-secondary);
            border: 2px solid var(--border-color);
            border-radius: 8px;
            cursor: pointer;
            font-size: 14px;
            font-weight: 500;
            transition: all 0.3s;
        }
        .tab.active {
            background: var(--accent);
            border-color: var(--accent);
            color: white;
        }
        .tab:hover:not(.active) {
            border-color: var(--accent);
            color: var(--accent);
        }
        .tab-content {
            display: none;
        }
        .tab-content.active {
            display: block;
        }
    </style>
</head>
<body class="admin-panel">
    <header class="header">
        <h1>⚙️ Já EntreGo Admin</h1>
        <nav>
            <a href="dashboard.php">Dashboard</a>
            <a href="entregas.php">Entregas</a>
            <a href="entregadores.php">Entregadores</a>
            <a href="usuarios.php">Usuários</a>
            <a href="parceiros.php">Parceiros</a>
            <a href="configuracoes.php">Configurações</a>
            <a href="perfil.php">Perfil</a>
            <a href="logout.php">Sair</a>
            <div class="theme-toggle">
                <button type="button" id="theme-toggle-btn" class="theme-toggle-btn" onclick="toggleTheme()" title="Alternar tema">🌙</button>
            </div>
        </nav>
    </header>
    
    <div class="container">
        <h2 style="margin-bottom: 20px;">👤 Perfil e Configurações</h2>
        
        <?php if ($sucesso): ?>
            <div class="alert alert-success"><?= htmlspecialchars($sucesso) ?></div>
        <?php endif; ?>
        
        <?php if ($erro): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($erro) ?></div>
        <?php endif; ?>
        
        <!-- Tabs -->
        <div class="tabs">
            <button class="tab active" onclick="showTab('empresa')">🏢 Dados da Empresa</button>
            <button class="tab" onclick="showTab('admin')">👤 Minha Conta</button>
            <button class="tab" onclick="showTab('senha')">🔒 Alterar Senha</button>
        </div>
        
        <!-- Tab: Dados da Empresa -->
        <div id="tab-empresa" class="tab-content active">
            <div class="perfil-section">
                <h3>🏢 Dados da Empresa</h3>
                <p style="color: #666; margin-bottom: 20px;">
                    Estas informações serão exibidas em todos os apps (cliente e entregador).
                </p>
                
                <form method="POST">
                    <div class="logo-preview">🚚</div>
                    
                    <div class="form-group">
                        <label>Nome da Empresa *</label>
                        <input type="text" name="nome_empresa" class="form-control" 
                               value="<?= htmlspecialchars($configs['nome_empresa'] ?? 'Já EntreGo') ?>" required>
                        <small style="color: #666;">Este nome aparecerá no cabeçalho de todos os apps</small>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Email de Contato</label>
                            <input type="email" name="email_empresa" class="form-control" 
                                   value="<?= htmlspecialchars($configs['email_empresa'] ?? '') ?>">
                        </div>
                        <div class="form-group">
                            <label>Telefone</label>
                            <input type="tel" name="telefone_empresa" class="form-control" 
                                   value="<?= htmlspecialchars($configs['telefone_empresa'] ?? '') ?>">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Endereço</label>
                        <input type="text" name="endereco_empresa" class="form-control" 
                               value="<?= htmlspecialchars($configs['endereco_empresa'] ?? '') ?>">
                    </div>
                    
                    <button type="submit" name="salvar_empresa" class="btn btn-primary">
                        💾 Salvar Dados da Empresa
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Tab: Minha Conta -->
        <div id="tab-admin" class="tab-content">
            <div class="perfil-section">
                <h3>👤 Minha Conta</h3>
                
                <form method="POST">
                    <div class="form-row">
                        <div class="form-group">
                            <label>Nome *</label>
                            <input type="text" name="admin_nome" class="form-control" 
                                   value="<?= htmlspecialchars($adminData['nome']) ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Email *</label>
                            <input type="email" name="admin_email" class="form-control" 
                                   value="<?= htmlspecialchars($adminData['email']) ?>" required>
                        </div>
                    </div>
                    
                    <button type="submit" name="salvar_admin" class="btn btn-primary">
                        💾 Salvar Alterações
                    </button>
                </form>
            </div>
        </div>
        
        <!-- Tab: Alterar Senha -->
        <div id="tab-senha" class="tab-content">
            <div class="perfil-section">
                <h3>🔒 Alterar Senha</h3>
                
                <form method="POST">
                    <div class="form-group">
                        <label>Senha Atual *</label>
                        <input type="password" name="senha_atual" class="form-control" required>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Nova Senha *</label>
                            <input type="password" name="nova_senha" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label>Confirmar Nova Senha *</label>
                            <input type="password" name="confirmar_senha" class="form-control" required>
                        </div>
                    </div>
                    
                    <button type="submit" name="alterar_senha" class="btn btn-primary">
                        🔒 Alterar Senha
                    </button>
                </form>
            </div>
        </div>
    </div>
    
    <script>
    function showTab(tab) {
        // Esconder todas as tabs
        document.querySelectorAll('.tab-content').forEach(el => el.classList.remove('active'));
        document.querySelectorAll('.tab').forEach(el => el.classList.remove('active'));
        
        // Mostrar tab selecionada
        document.getElementById('tab-' + tab).classList.add('active');
        event.target.classList.add('active');
    }
    </script>
</body>
</html>
