<?php
/**
 * Funções auxiliares do sistema
 */

/**
 * Retorna o nome da empresa
 */
function getNomeEmpresa() {
    return getConfig('nome_empresa', 'Já EntreGo');
}

/**
 * Busca uma configuração do sistema
 */
function getConfig($chave, $default = null) {
    static $cache = [];
    
    if (isset($cache[$chave])) {
        return $cache[$chave];
    }
    
    try {
        $db = Database::getInstance()->getConnection();
        $stmt = $db->prepare("SELECT valor FROM configuracoes WHERE chave = ?");
        $stmt->execute([$chave]);
        $result = $stmt->fetch(PDO::FETCH_ASSOC);
        
        $cache[$chave] = $result ? $result['valor'] : $default;
        return $cache[$chave];
    } catch (Exception $e) {
        return $default;
    }
}

/**
 * Calcula o valor líquido que o entregador recebe
 */
function calcularGanhoEntregador($valorEntrega) {
    $taxaPercentual = floatval(getConfig('taxa_entregador_percentual', 15));
    $taxaFixa = floatval(getConfig('taxa_entregador_fixa', 0));
    
    $desconto = ($valorEntrega * ($taxaPercentual / 100)) + $taxaFixa;
    $ganhoLiquido = $valorEntrega - $desconto;
    
    return max(0, $ganhoLiquido); // Nunca retorna negativo
}

/**
 * Calcula o valor da taxa da plataforma
 */
function calcularTaxaPlataforma($valorEntrega) {
    $taxaPercentual = floatval(getConfig('taxa_entregador_percentual', 15));
    $taxaFixa = floatval(getConfig('taxa_entregador_fixa', 0));
    
    return ($valorEntrega * ($taxaPercentual / 100)) + $taxaFixa;
}

/**
 * Calcula o valor de uma entrega baseado na distância
 */
function calcularValorEntrega($distanciaKm) {
    $valorMinimo = floatval(getConfig('valor_minimo_entrega', 10));
    $valorPorKm = floatval(getConfig('valor_por_km', 2.50));
    
    $valor = $valorPorKm * $distanciaKm;
    
    return max($valorMinimo, $valor);
}
