<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn('entregador')) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

$entregaId = intval($_POST['entrega_id'] ?? 0);
if (!$entregaId) {
    echo json_encode(['success' => false, 'message' => 'ID inválido']);
    exit;
}

$db = Database::getInstance()->getConnection();
$entregadorId = getCurrentUserId('entregador');

// Verificar se entrega ainda está disponível
$stmt = $db->prepare("SELECT id FROM entregas WHERE id = ? AND status = 'pendente'");
$stmt->execute([$entregaId]);
if (!$stmt->fetch()) {
    echo json_encode(['success' => false, 'message' => 'Entrega não disponível']);
    exit;
}

// Verificar se entregador não tem outra entrega em andamento
$stmt = $db->prepare("SELECT id FROM entregas WHERE entregador_id = ? AND status IN ('aceita', 'coletada')");
$stmt->execute([$entregadorId]);
if ($stmt->fetch()) {
    echo json_encode(['success' => false, 'message' => 'Você já tem uma entrega em andamento']);
    exit;
}

// Aceitar entrega
$stmt = $db->prepare("UPDATE entregas SET entregador_id = ?, status = 'aceita' WHERE id = ? AND status = 'pendente'");
$result = $stmt->execute([$entregadorId, $entregaId]);

if ($result && $stmt->rowCount() > 0) {
    // Atualizar status do entregador
    $stmt = $db->prepare("UPDATE entregadores SET status = 'ocupado' WHERE id = ?");
    $stmt->execute([$entregadorId]);
    
    // Buscar dados para notificação
    $stmt = $db->prepare("SELECT e.usuario_id, ent.nome as entregador_nome FROM entregas e JOIN entregadores ent ON ent.id = ? WHERE e.id = ?");
    $stmt->execute([$entregadorId, $entregaId]);
    $dados = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Criar notificação para o cliente
    if ($dados) {
        $msg = "Sua entrega foi aceita por " . $dados['entregador_nome'] . "!";
        $stmt = $db->prepare("INSERT INTO notificacoes_cliente (usuario_id, entrega_id, tipo, mensagem) VALUES (?, ?, 'aceita', ?)");
        $stmt->execute([$dados['usuario_id'], $entregaId, $msg]);
    }
    
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Entrega já foi aceita por outro entregador']);
}
