<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn('entregador')) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

$entregaId = intval($_POST['entrega_id'] ?? 0);
$status = $_POST['status'] ?? '';

if (!$entregaId || !in_array($status, ['coletada', 'entregue'])) {
    echo json_encode(['success' => false, 'message' => 'Dados inválidos']);
    exit;
}

$db = Database::getInstance()->getConnection();
$entregadorId = getCurrentUserId('entregador');

// Verificar se a entrega pertence ao entregador
$stmt = $db->prepare("SELECT id, status FROM entregas WHERE id = ? AND entregador_id = ?");
$stmt->execute([$entregaId, $entregadorId]);
$entrega = $stmt->fetch(PDO::FETCH_ASSOC);

if (!$entrega) {
    echo json_encode(['success' => false, 'message' => 'Entrega não encontrada']);
    exit;
}

// Validar transição de status
$transicaoValida = ($entrega['status'] === 'aceita' && $status === 'coletada') ||
                   ($entrega['status'] === 'coletada' && $status === 'entregue');

if (!$transicaoValida) {
    echo json_encode(['success' => false, 'message' => 'Transição de status inválida']);
    exit;
}

// Atualizar status
$stmt = $db->prepare("UPDATE entregas SET status = ? WHERE id = ?");
$result = $stmt->execute([$status, $entregaId]);

if ($result) {
    // Buscar dados para notificação
    $stmt = $db->prepare("SELECT e.usuario_id, ent.nome as entregador_nome FROM entregas e JOIN entregadores ent ON ent.id = ? WHERE e.id = ?");
    $stmt->execute([$entregadorId, $entregaId]);
    $dados = $stmt->fetch(PDO::FETCH_ASSOC);
    
    // Criar notificação para o cliente
    if ($dados) {
        if ($status === 'coletada') {
            $msg = $dados['entregador_nome'] . " coletou seu pacote e está a caminho!";
        } else {
            $msg = "Sua entrega foi realizada com sucesso! 🎉";
        }
        $stmt = $db->prepare("INSERT INTO notificacoes_cliente (usuario_id, entrega_id, tipo, mensagem) VALUES (?, ?, ?, ?)");
        $stmt->execute([$dados['usuario_id'], $entregaId, $status, $msg]);
    }
    
    // Se entregue, liberar entregador
    if ($status === 'entregue') {
        $stmt = $db->prepare("UPDATE entregadores SET status = 'disponivel' WHERE id = ?");
        $stmt->execute([$entregadorId]);
    }
    echo json_encode(['success' => true]);
} else {
    echo json_encode(['success' => false, 'message' => 'Erro ao atualizar']);
}
