<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn('entregador')) {
    echo json_encode(['success' => false, 'message' => 'Não autorizado']);
    exit;
}

$lat = floatval($_POST['lat'] ?? 0);
$lng = floatval($_POST['lng'] ?? 0);

if ($lat == 0 || $lng == 0) {
    echo json_encode(['success' => false, 'message' => 'Coordenadas inválidas']);
    exit;
}

$db = Database::getInstance()->getConnection();
$stmt = $db->prepare("UPDATE entregadores SET latitude = ?, longitude = ? WHERE id = ?");
$result = $stmt->execute([$lat, $lng, getCurrentUserId('entregador')]);

echo json_encode(['success' => $result]);
