<?php
require_once '../../config/database.php';
require_once '../../config/auth.php';

header('Content-Type: application/json');

if (!isLoggedIn('entregador')) {
    echo json_encode(['novas' => []]);
    exit;
}

$db = Database::getInstance()->getConnection();
$entregadorId = getCurrentUserId('entregador');

// Buscar notificações não lidas dos últimos 30 segundos
$stmt = $db->prepare("
    SELECT n.id, n.mensagem, n.entrega_id, e.valor
    FROM notificacoes n
    JOIN entregas e ON n.entrega_id = e.id
    WHERE n.entregador_id = ? 
    AND n.lida = 0 
    AND n.created_at >= DATE_SUB(NOW(), INTERVAL 30 SECOND)
    AND e.status = 'pendente'
    ORDER BY n.created_at DESC
");
$stmt->execute([$entregadorId]);
$notificacoes = $stmt->fetchAll(PDO::FETCH_ASSOC);

// Marcar como lidas
if (!empty($notificacoes)) {
    $ids = array_column($notificacoes, 'id');
    $placeholders = implode(',', array_fill(0, count($ids), '?'));
    $stmt = $db->prepare("UPDATE notificacoes SET lida = 1 WHERE id IN ($placeholders)");
    $stmt->execute($ids);
}

echo json_encode(['novas' => $notificacoes]);
