<?php
require_once '../config/database.php';
require_once '../config/auth.php';
requireLogin('entregador', 'index.php');

$db = Database::getInstance()->getConnection();
$entregadorId = getCurrentUserId('entregador');

// Buscar histórico de entregas
$stmt = $db->prepare("
    SELECT e.*, u.nome as cliente_nome
    FROM entregas e
    JOIN usuarios u ON e.usuario_id = u.id
    WHERE e.entregador_id = ?
    ORDER BY e.updated_at DESC
    LIMIT 50
");
$stmt->execute([$entregadorId]);
$entregas = $stmt->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Histórico - Entregador</title>
    <link rel="stylesheet" href="../assets/css/style.css">
    <link rel="stylesheet" href="../assets/css/entregador.css">
</head>
<body class="entregador">
    <header class="header-entregador">
        <h1>📋 Histórico</h1>
    </header>
    
    <main class="main-content">
        <?php if (empty($entregas)): ?>
            <div class="sem-entregas">
                <div class="icon">📭</div>
                <h3>Nenhuma entrega realizada</h3>
                <p>Seu histórico aparecerá aqui</p>
            </div>
        <?php else: ?>
            <?php foreach ($entregas as $entrega): ?>
                <div class="historico-item">
                    <div class="info">
                        <h4><?= htmlspecialchars($entrega['destino_endereco']) ?></h4>
                        <p>
                            <span class="badge badge-<?= $entrega['status'] ?>"><?= ucfirst($entrega['status']) ?></span>
                            <?= date('d/m/Y H:i', strtotime($entrega['updated_at'])) ?>
                        </p>
                    </div>
                    <div class="valor">R$ <?= number_format($entrega['valor'], 2, ',', '.') ?></div>
                </div>
            <?php endforeach; ?>
        <?php endif; ?>
    </main>
    
    <nav class="bottom-nav">
        <a href="dashboard.php">
            <span class="icon">🏠</span>
            Início
        </a>
        <a href="historico.php" class="active">
            <span class="icon">📋</span>
            Histórico
        </a>
        <a href="ganhos.php">
            <span class="icon">💰</span>
            Ganhos
        </a>
        <a href="logout.php">
            <span class="icon">🚪</span>
            Sair
        </a>
    </nav>
</body>
</html>
