<?php
require_once 'config/database.php';
require_once 'config/auth.php';

if (isLoggedIn('usuario')) {
    header('Location: cliente/dashboard.php');
    exit;
}

$erro = '';

// Verificar se há mensagem de bloqueio na sessão
if (isset($_SESSION['erro_bloqueio'])) {
    $erro = $_SESSION['erro_bloqueio'];
    unset($_SESSION['erro_bloqueio']);
}

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $email = $_POST['email'] ?? '';
    $senha = $_POST['senha'] ?? '';
    
    $db = Database::getInstance()->getConnection();
    $stmt = $db->prepare("SELECT id, nome, email, senha, bloqueado, motivo_bloqueio FROM usuarios WHERE email = ?");
    $stmt->execute([$email]);
    $usuario = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($usuario && password_verify($senha, $usuario['senha'])) {
        // Verificar se está bloqueado
        if (!empty($usuario['bloqueado']) && $usuario['bloqueado'] == 1) {
            $erro = '🔒 Atenção! Seu acesso foi temporariamente bloqueado por questões de segurança ou pendências em sua conta. Para mais informações e regularização, entre em contato com nosso suporte pelos canais oficiais. Estamos à disposição para ajudar.';
        } else {
            login('usuario', $usuario['id'], $usuario['nome'], $usuario['email']);
            header('Location: cliente/dashboard.php');
            exit;
        }
    } else {
        $erro = 'Email ou senha inválidos';
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Já EntreGo - Login</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <div class="login-container">
        <div class="login-box">
            <div class="logo">🚚</div>
            <h2>Já EntreGo</h2>
            
            <?php if ($erro): ?>
                <div class="alert alert-danger" style="<?= strpos($erro, '🔒') !== false ? 'background: #fff3cd; border: 1px solid #ffc107; color: #856404; padding: 15px; line-height: 1.5;' : '' ?>"><?= htmlspecialchars($erro) ?></div>
            <?php endif; ?>
            
            <form method="POST">
                <div class="form-group">
                    <label>Email</label>
                    <input type="email" name="email" class="form-control" required>
                </div>
                <div class="form-group">
                    <label>Senha</label>
                    <input type="password" name="senha" class="form-control" required>
                </div>
                <button type="submit" class="btn btn-primary btn-block">Entrar</button>
            </form>
            
            <p style="text-align: center; margin-top: 20px; color: #666;">
                Não tem conta? <a href="cadastro.php" style="color: var(--primary);">Cadastre-se</a>
            </p>
            <p style="text-align: center; margin-top: 10px;">
                <a href="entregador/index.php" style="color: var(--primary);">Sou Entregador</a> |
                <a href="parceiro.php" style="color: var(--primary);">Seja Parceiro</a> |
                <a href="admin/index.php" style="color: var(--primary);">Admin</a>
            </p>
        </div>
    </div>
</body>
</html>
